/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.IpCidrListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticationProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthenticationProfile> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(AuthenticationProfile.getter(AuthenticationProfile::id)).setter(AuthenticationProfile.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AuthenticationProfile.getter(AuthenticationProfile::arn)).setter(AuthenticationProfile.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AuthenticationProfile.getter(AuthenticationProfile::name)).setter(AuthenticationProfile.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AuthenticationProfile.getter(AuthenticationProfile::description)).setter(AuthenticationProfile.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> ALLOWED_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedIps").getter(AuthenticationProfile.getter(AuthenticationProfile::allowedIps)).setter(AuthenticationProfile.setter(Builder::allowedIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BLOCKED_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockedIps").getter(AuthenticationProfile.getter(AuthenticationProfile::blockedIps)).setter(AuthenticationProfile.setter(Builder::blockedIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockedIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefault").getter(AuthenticationProfile.getter(AuthenticationProfile::isDefault)).setter(AuthenticationProfile.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(AuthenticationProfile.getter(AuthenticationProfile::createdTime)).setter(AuthenticationProfile.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(AuthenticationProfile.getter(AuthenticationProfile::lastModifiedTime)).setter(AuthenticationProfile.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedRegion").getter(AuthenticationProfile.getter(AuthenticationProfile::lastModifiedRegion)).setter(AuthenticationProfile.setter(Builder::lastModifiedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build()}).build();
    private static final SdkField<Integer> PERIODIC_SESSION_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PeriodicSessionDuration").getter(AuthenticationProfile.getter(AuthenticationProfile::periodicSessionDuration)).setter(AuthenticationProfile.setter(Builder::periodicSessionDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodicSessionDuration").build()}).build();
    private static final SdkField<Integer> MAX_SESSION_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxSessionDuration").getter(AuthenticationProfile.getter(AuthenticationProfile::maxSessionDuration)).setter(AuthenticationProfile.setter(Builder::maxSessionDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSessionDuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ALLOWED_IPS_FIELD, BLOCKED_IPS_FIELD, IS_DEFAULT_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD, PERIODIC_SESSION_DURATION_FIELD, MAX_SESSION_DURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthenticationProfile.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String name;
    private final String description;
    private final List<String> allowedIps;
    private final List<String> blockedIps;
    private final Boolean isDefault;
    private final Instant createdTime;
    private final Instant lastModifiedTime;
    private final String lastModifiedRegion;
    private final Integer periodicSessionDuration;
    private final Integer maxSessionDuration;

    private AuthenticationProfile(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.allowedIps = builder.allowedIps;
        this.blockedIps = builder.blockedIps;
        this.isDefault = builder.isDefault;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
        this.periodicSessionDuration = builder.periodicSessionDuration;
        this.maxSessionDuration = builder.maxSessionDuration;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasAllowedIps() {
        return this.allowedIps != null && !(this.allowedIps instanceof SdkAutoConstructList);
    }

    public final List<String> allowedIps() {
        return this.allowedIps;
    }

    public final boolean hasBlockedIps() {
        return this.blockedIps != null && !(this.blockedIps instanceof SdkAutoConstructList);
    }

    public final List<String> blockedIps() {
        return this.blockedIps;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    public final Integer periodicSessionDuration() {
        return this.periodicSessionDuration;
    }

    public final Integer maxSessionDuration() {
        return this.maxSessionDuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedIps() ? this.allowedIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockedIps() ? this.blockedIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodicSessionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSessionDuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationProfile)) {
            return false;
        }
        AuthenticationProfile other = (AuthenticationProfile)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasAllowedIps() == other.hasAllowedIps() && Objects.equals(this.allowedIps(), other.allowedIps()) && this.hasBlockedIps() == other.hasBlockedIps() && Objects.equals(this.blockedIps(), other.blockedIps()) && Objects.equals(this.isDefault(), other.isDefault()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedRegion(), other.lastModifiedRegion()) && Objects.equals(this.periodicSessionDuration(), other.periodicSessionDuration()) && Objects.equals(this.maxSessionDuration(), other.maxSessionDuration());
    }

    public final String toString() {
        return ToString.builder((String)"AuthenticationProfile").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("AllowedIps", this.hasAllowedIps() ? this.allowedIps() : null).add("BlockedIps", this.hasBlockedIps() ? this.blockedIps() : null).add("IsDefault", (Object)this.isDefault()).add("CreatedTime", (Object)this.createdTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedRegion", (Object)this.lastModifiedRegion()).add("PeriodicSessionDuration", (Object)this.periodicSessionDuration()).add("MaxSessionDuration", (Object)this.maxSessionDuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AllowedIps": {
                return Optional.ofNullable(clazz.cast(this.allowedIps()));
            }
            case "BlockedIps": {
                return Optional.ofNullable(clazz.cast(this.blockedIps()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedRegion()));
            }
            case "PeriodicSessionDuration": {
                return Optional.ofNullable(clazz.cast(this.periodicSessionDuration()));
            }
            case "MaxSessionDuration": {
                return Optional.ofNullable(clazz.cast(this.maxSessionDuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AllowedIps", ALLOWED_IPS_FIELD);
        map.put("BlockedIps", BLOCKED_IPS_FIELD);
        map.put("IsDefault", IS_DEFAULT_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        map.put("PeriodicSessionDuration", PERIODIC_SESSION_DURATION_FIELD);
        map.put("MaxSessionDuration", MAX_SESSION_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationProfile, T> g) {
        return obj -> g.apply((AuthenticationProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private String description;
        private List<String> allowedIps = DefaultSdkAutoConstructList.getInstance();
        private List<String> blockedIps = DefaultSdkAutoConstructList.getInstance();
        private Boolean isDefault;
        private Instant createdTime;
        private Instant lastModifiedTime;
        private String lastModifiedRegion;
        private Integer periodicSessionDuration;
        private Integer maxSessionDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationProfile model) {
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.allowedIps(model.allowedIps);
            this.blockedIps(model.blockedIps);
            this.isDefault(model.isDefault);
            this.createdTime(model.createdTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedRegion(model.lastModifiedRegion);
            this.periodicSessionDuration(model.periodicSessionDuration);
            this.maxSessionDuration(model.maxSessionDuration);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getAllowedIps() {
            if (this.allowedIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedIps;
        }

        public final void setAllowedIps(Collection<String> allowedIps) {
            this.allowedIps = IpCidrListCopier.copy(allowedIps);
        }

        @Override
        public final Builder allowedIps(Collection<String> allowedIps) {
            this.allowedIps = IpCidrListCopier.copy(allowedIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedIps(String ... allowedIps) {
            this.allowedIps(Arrays.asList(allowedIps));
            return this;
        }

        public final Collection<String> getBlockedIps() {
            if (this.blockedIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.blockedIps;
        }

        public final void setBlockedIps(Collection<String> blockedIps) {
            this.blockedIps = IpCidrListCopier.copy(blockedIps);
        }

        @Override
        public final Builder blockedIps(Collection<String> blockedIps) {
            this.blockedIps = IpCidrListCopier.copy(blockedIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedIps(String ... blockedIps) {
            this.blockedIps(Arrays.asList(blockedIps));
            return this;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return this.lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public final Integer getPeriodicSessionDuration() {
            return this.periodicSessionDuration;
        }

        public final void setPeriodicSessionDuration(Integer periodicSessionDuration) {
            this.periodicSessionDuration = periodicSessionDuration;
        }

        @Override
        public final Builder periodicSessionDuration(Integer periodicSessionDuration) {
            this.periodicSessionDuration = periodicSessionDuration;
            return this;
        }

        public final Integer getMaxSessionDuration() {
            return this.maxSessionDuration;
        }

        public final void setMaxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
        }

        @Override
        public final Builder maxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
            return this;
        }

        public AuthenticationProfile build() {
            return new AuthenticationProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthenticationProfile> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder allowedIps(Collection<String> var1);

        public Builder allowedIps(String ... var1);

        public Builder blockedIps(Collection<String> var1);

        public Builder blockedIps(String ... var1);

        public Builder isDefault(Boolean var1);

        public Builder createdTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedRegion(String var1);

        public Builder periodicSessionDuration(Integer var1);

        public Builder maxSessionDuration(Integer var1);
    }
}

