/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.QuickConnect;
import software.amazon.awssdk.services.connect.model.SearchQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.SearchQuickConnectsResponse;

public class SearchQuickConnectsPublisher
implements SdkPublisher<SearchQuickConnectsResponse> {
    private final ConnectAsyncClient client;
    private final SearchQuickConnectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchQuickConnectsPublisher(ConnectAsyncClient client, SearchQuickConnectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchQuickConnectsPublisher(ConnectAsyncClient client, SearchQuickConnectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchQuickConnectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchQuickConnectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<QuickConnect> quickConnects() {
        Function<SearchQuickConnectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.quickConnects() != null) {
                return response.quickConnects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchQuickConnectsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchQuickConnectsResponseFetcher
    implements AsyncPageFetcher<SearchQuickConnectsResponse> {
        private SearchQuickConnectsResponseFetcher() {
        }

        public boolean hasNextPage(SearchQuickConnectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchQuickConnectsResponse> nextPage(SearchQuickConnectsResponse previousPage) {
            if (previousPage == null) {
                return SearchQuickConnectsPublisher.this.client.searchQuickConnects(SearchQuickConnectsPublisher.this.firstRequest);
            }
            return SearchQuickConnectsPublisher.this.client.searchQuickConnects((SearchQuickConnectsRequest)((Object)SearchQuickConnectsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

