/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.UseCase;
import software.amazon.awssdk.services.connect.model.UseCaseSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUseCasesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListUseCasesResponse> {
    private static final SdkField<List<UseCase>> USE_CASE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UseCaseSummaryList").getter(ListUseCasesResponse.getter(ListUseCasesResponse::useCaseSummaryList)).setter(ListUseCasesResponse.setter(Builder::useCaseSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCaseSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UseCase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListUseCasesResponse.getter(ListUseCasesResponse::nextToken)).setter(ListUseCasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USE_CASE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListUseCasesResponse.memberNameToFieldInitializer();
    private final List<UseCase> useCaseSummaryList;
    private final String nextToken;

    private ListUseCasesResponse(BuilderImpl builder) {
        super(builder);
        this.useCaseSummaryList = builder.useCaseSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasUseCaseSummaryList() {
        return this.useCaseSummaryList != null && !(this.useCaseSummaryList instanceof SdkAutoConstructList);
    }

    public final List<UseCase> useCaseSummaryList() {
        return this.useCaseSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUseCaseSummaryList() ? this.useCaseSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUseCasesResponse)) {
            return false;
        }
        ListUseCasesResponse other = (ListUseCasesResponse)((Object)obj);
        return this.hasUseCaseSummaryList() == other.hasUseCaseSummaryList() && Objects.equals(this.useCaseSummaryList(), other.useCaseSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListUseCasesResponse").add("UseCaseSummaryList", this.hasUseCaseSummaryList() ? this.useCaseSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UseCaseSummaryList": {
                return Optional.ofNullable(clazz.cast(this.useCaseSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UseCaseSummaryList", USE_CASE_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUseCasesResponse, T> g) {
        return obj -> g.apply((ListUseCasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<UseCase> useCaseSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUseCasesResponse model) {
            super(model);
            this.useCaseSummaryList(model.useCaseSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<UseCase.Builder> getUseCaseSummaryList() {
            List<UseCase.Builder> result = UseCaseSummaryListCopier.copyToBuilder(this.useCaseSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUseCaseSummaryList(Collection<UseCase.BuilderImpl> useCaseSummaryList) {
            this.useCaseSummaryList = UseCaseSummaryListCopier.copyFromBuilder(useCaseSummaryList);
        }

        @Override
        public final Builder useCaseSummaryList(Collection<UseCase> useCaseSummaryList) {
            this.useCaseSummaryList = UseCaseSummaryListCopier.copy(useCaseSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder useCaseSummaryList(UseCase ... useCaseSummaryList) {
            this.useCaseSummaryList(Arrays.asList(useCaseSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder useCaseSummaryList(Consumer<UseCase.Builder> ... useCaseSummaryList) {
            this.useCaseSummaryList(Stream.of(useCaseSummaryList).map(c -> (UseCase)((UseCase.Builder)UseCase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListUseCasesResponse build() {
            return new ListUseCasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUseCasesResponse> {
        public Builder useCaseSummaryList(Collection<UseCase> var1);

        public Builder useCaseSummaryList(UseCase ... var1);

        public Builder useCaseSummaryList(Consumer<UseCase.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

