/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.PhoneType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserPhoneConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserPhoneConfig> {
    private static final SdkField<String> PHONE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneType").getter(UserPhoneConfig.getter(UserPhoneConfig::phoneTypeAsString)).setter(UserPhoneConfig.setter(Builder::phoneType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneType").build()}).build();
    private static final SdkField<Boolean> AUTO_ACCEPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoAccept").getter(UserPhoneConfig.getter(UserPhoneConfig::autoAccept)).setter(UserPhoneConfig.setter(Builder::autoAccept)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAccept").build()}).build();
    private static final SdkField<Integer> AFTER_CONTACT_WORK_TIME_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AfterContactWorkTimeLimit").getter(UserPhoneConfig.getter(UserPhoneConfig::afterContactWorkTimeLimit)).setter(UserPhoneConfig.setter(Builder::afterContactWorkTimeLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterContactWorkTimeLimit").build()}).build();
    private static final SdkField<String> DESK_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeskPhoneNumber").getter(UserPhoneConfig.getter(UserPhoneConfig::deskPhoneNumber)).setter(UserPhoneConfig.setter(Builder::deskPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeskPhoneNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_TYPE_FIELD, AUTO_ACCEPT_FIELD, AFTER_CONTACT_WORK_TIME_LIMIT_FIELD, DESK_PHONE_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UserPhoneConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String phoneType;
    private final Boolean autoAccept;
    private final Integer afterContactWorkTimeLimit;
    private final String deskPhoneNumber;

    private UserPhoneConfig(BuilderImpl builder) {
        this.phoneType = builder.phoneType;
        this.autoAccept = builder.autoAccept;
        this.afterContactWorkTimeLimit = builder.afterContactWorkTimeLimit;
        this.deskPhoneNumber = builder.deskPhoneNumber;
    }

    public final PhoneType phoneType() {
        return PhoneType.fromValue(this.phoneType);
    }

    public final String phoneTypeAsString() {
        return this.phoneType;
    }

    public final Boolean autoAccept() {
        return this.autoAccept;
    }

    public final Integer afterContactWorkTimeLimit() {
        return this.afterContactWorkTimeLimit;
    }

    public final String deskPhoneNumber() {
        return this.deskPhoneNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAccept());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterContactWorkTimeLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.deskPhoneNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPhoneConfig)) {
            return false;
        }
        UserPhoneConfig other = (UserPhoneConfig)obj;
        return Objects.equals(this.phoneTypeAsString(), other.phoneTypeAsString()) && Objects.equals(this.autoAccept(), other.autoAccept()) && Objects.equals(this.afterContactWorkTimeLimit(), other.afterContactWorkTimeLimit()) && Objects.equals(this.deskPhoneNumber(), other.deskPhoneNumber());
    }

    public final String toString() {
        return ToString.builder((String)"UserPhoneConfig").add("PhoneType", (Object)this.phoneTypeAsString()).add("AutoAccept", (Object)this.autoAccept()).add("AfterContactWorkTimeLimit", (Object)this.afterContactWorkTimeLimit()).add("DeskPhoneNumber", (Object)this.deskPhoneNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneType": {
                return Optional.ofNullable(clazz.cast(this.phoneTypeAsString()));
            }
            case "AutoAccept": {
                return Optional.ofNullable(clazz.cast(this.autoAccept()));
            }
            case "AfterContactWorkTimeLimit": {
                return Optional.ofNullable(clazz.cast(this.afterContactWorkTimeLimit()));
            }
            case "DeskPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.deskPhoneNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PhoneType", PHONE_TYPE_FIELD);
        map.put("AutoAccept", AUTO_ACCEPT_FIELD);
        map.put("AfterContactWorkTimeLimit", AFTER_CONTACT_WORK_TIME_LIMIT_FIELD);
        map.put("DeskPhoneNumber", DESK_PHONE_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserPhoneConfig, T> g) {
        return obj -> g.apply((UserPhoneConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String phoneType;
        private Boolean autoAccept;
        private Integer afterContactWorkTimeLimit;
        private String deskPhoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPhoneConfig model) {
            this.phoneType(model.phoneType);
            this.autoAccept(model.autoAccept);
            this.afterContactWorkTimeLimit(model.afterContactWorkTimeLimit);
            this.deskPhoneNumber(model.deskPhoneNumber);
        }

        public final String getPhoneType() {
            return this.phoneType;
        }

        public final void setPhoneType(String phoneType) {
            this.phoneType = phoneType;
        }

        @Override
        public final Builder phoneType(String phoneType) {
            this.phoneType = phoneType;
            return this;
        }

        @Override
        public final Builder phoneType(PhoneType phoneType) {
            this.phoneType(phoneType == null ? null : phoneType.toString());
            return this;
        }

        public final Boolean getAutoAccept() {
            return this.autoAccept;
        }

        public final void setAutoAccept(Boolean autoAccept) {
            this.autoAccept = autoAccept;
        }

        @Override
        public final Builder autoAccept(Boolean autoAccept) {
            this.autoAccept = autoAccept;
            return this;
        }

        public final Integer getAfterContactWorkTimeLimit() {
            return this.afterContactWorkTimeLimit;
        }

        public final void setAfterContactWorkTimeLimit(Integer afterContactWorkTimeLimit) {
            this.afterContactWorkTimeLimit = afterContactWorkTimeLimit;
        }

        @Override
        public final Builder afterContactWorkTimeLimit(Integer afterContactWorkTimeLimit) {
            this.afterContactWorkTimeLimit = afterContactWorkTimeLimit;
            return this;
        }

        public final String getDeskPhoneNumber() {
            return this.deskPhoneNumber;
        }

        public final void setDeskPhoneNumber(String deskPhoneNumber) {
            this.deskPhoneNumber = deskPhoneNumber;
        }

        @Override
        public final Builder deskPhoneNumber(String deskPhoneNumber) {
            this.deskPhoneNumber = deskPhoneNumber;
            return this;
        }

        public UserPhoneConfig build() {
            return new UserPhoneConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserPhoneConfig> {
        public Builder phoneType(String var1);

        public Builder phoneType(PhoneType var1);

        public Builder autoAccept(Boolean var1);

        public Builder afterContactWorkTimeLimit(Integer var1);

        public Builder deskPhoneNumber(String var1);
    }
}

