/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.TaskTemplateConstraints;
import software.amazon.awssdk.services.connect.model.TaskTemplateDefaults;
import software.amazon.awssdk.services.connect.model.TaskTemplateField;
import software.amazon.awssdk.services.connect.model.TaskTemplateFieldsCopier;
import software.amazon.awssdk.services.connect.model.TaskTemplateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTaskTemplateRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateTaskTemplateRequest> {
    private static final SdkField<String> TASK_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskTemplateId").getter(UpdateTaskTemplateRequest.getter(UpdateTaskTemplateRequest::taskTemplateId)).setter(UpdateTaskTemplateRequest.setter(Builder::taskTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("TaskTemplateId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateTaskTemplateRequest.getter(UpdateTaskTemplateRequest::instanceId)).setter(UpdateTaskTemplateRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateTaskTemplateRequest.getter(UpdateTaskTemplateRequest::name)).setter(UpdateTaskTemplateRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateTaskTemplateRequest.getter(UpdateTaskTemplateRequest::description)).setter(UpdateTaskTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactFlowId").getter(UpdateTaskTemplateRequest.getter(UpdateTaskTemplateRequest::contactFlowId)).setter(UpdateTaskTemplateRequest.setter(Builder::contactFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()}).build();
    private static final SdkField<String> SELF_ASSIGN_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelfAssignFlowId").getter(UpdateTaskTemplateRequest.getter(UpdateTaskTemplateRequest::selfAssignFlowId)).setter(UpdateTaskTemplateRequest.setter(Builder::selfAssignFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfAssignFlowId").build()}).build();
    private static final SdkField<TaskTemplateConstraints> CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Constraints").getter(UpdateTaskTemplateRequest.getter(UpdateTaskTemplateRequest::constraints)).setter(UpdateTaskTemplateRequest.setter(Builder::constraints)).constructor(TaskTemplateConstraints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constraints").build()}).build();
    private static final SdkField<TaskTemplateDefaults> DEFAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Defaults").getter(UpdateTaskTemplateRequest.getter(UpdateTaskTemplateRequest::defaults)).setter(UpdateTaskTemplateRequest.setter(Builder::defaults)).constructor(TaskTemplateDefaults::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Defaults").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(UpdateTaskTemplateRequest.getter(UpdateTaskTemplateRequest::statusAsString)).setter(UpdateTaskTemplateRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<TaskTemplateField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Fields").getter(UpdateTaskTemplateRequest.getter(UpdateTaskTemplateRequest::fields)).setter(UpdateTaskTemplateRequest.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskTemplateField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_TEMPLATE_ID_FIELD, INSTANCE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CONTACT_FLOW_ID_FIELD, SELF_ASSIGN_FLOW_ID_FIELD, CONSTRAINTS_FIELD, DEFAULTS_FIELD, STATUS_FIELD, FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTaskTemplateRequest.memberNameToFieldInitializer();
    private final String taskTemplateId;
    private final String instanceId;
    private final String name;
    private final String description;
    private final String contactFlowId;
    private final String selfAssignFlowId;
    private final TaskTemplateConstraints constraints;
    private final TaskTemplateDefaults defaults;
    private final String status;
    private final List<TaskTemplateField> fields;

    private UpdateTaskTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.taskTemplateId = builder.taskTemplateId;
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.description = builder.description;
        this.contactFlowId = builder.contactFlowId;
        this.selfAssignFlowId = builder.selfAssignFlowId;
        this.constraints = builder.constraints;
        this.defaults = builder.defaults;
        this.status = builder.status;
        this.fields = builder.fields;
    }

    public final String taskTemplateId() {
        return this.taskTemplateId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String contactFlowId() {
        return this.contactFlowId;
    }

    public final String selfAssignFlowId() {
        return this.selfAssignFlowId;
    }

    public final TaskTemplateConstraints constraints() {
        return this.constraints;
    }

    public final TaskTemplateDefaults defaults() {
        return this.defaults;
    }

    public final TaskTemplateStatus status() {
        return TaskTemplateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public final List<TaskTemplateField> fields() {
        return this.fields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfAssignFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.constraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaults());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTaskTemplateRequest)) {
            return false;
        }
        UpdateTaskTemplateRequest other = (UpdateTaskTemplateRequest)((Object)obj);
        return Objects.equals(this.taskTemplateId(), other.taskTemplateId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.contactFlowId(), other.contactFlowId()) && Objects.equals(this.selfAssignFlowId(), other.selfAssignFlowId()) && Objects.equals(this.constraints(), other.constraints()) && Objects.equals(this.defaults(), other.defaults()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTaskTemplateRequest").add("TaskTemplateId", (Object)this.taskTemplateId()).add("InstanceId", (Object)this.instanceId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ContactFlowId", (Object)this.contactFlowId()).add("SelfAssignFlowId", (Object)this.selfAssignFlowId()).add("Constraints", (Object)this.constraints()).add("Defaults", (Object)this.defaults()).add("Status", (Object)this.statusAsString()).add("Fields", this.hasFields() ? this.fields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskTemplateId": {
                return Optional.ofNullable(clazz.cast(this.taskTemplateId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ContactFlowId": {
                return Optional.ofNullable(clazz.cast(this.contactFlowId()));
            }
            case "SelfAssignFlowId": {
                return Optional.ofNullable(clazz.cast(this.selfAssignFlowId()));
            }
            case "Constraints": {
                return Optional.ofNullable(clazz.cast(this.constraints()));
            }
            case "Defaults": {
                return Optional.ofNullable(clazz.cast(this.defaults()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TaskTemplateId", TASK_TEMPLATE_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ContactFlowId", CONTACT_FLOW_ID_FIELD);
        map.put("SelfAssignFlowId", SELF_ASSIGN_FLOW_ID_FIELD);
        map.put("Constraints", CONSTRAINTS_FIELD);
        map.put("Defaults", DEFAULTS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Fields", FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTaskTemplateRequest, T> g) {
        return obj -> g.apply((UpdateTaskTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String taskTemplateId;
        private String instanceId;
        private String name;
        private String description;
        private String contactFlowId;
        private String selfAssignFlowId;
        private TaskTemplateConstraints constraints;
        private TaskTemplateDefaults defaults;
        private String status;
        private List<TaskTemplateField> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTaskTemplateRequest model) {
            super(model);
            this.taskTemplateId(model.taskTemplateId);
            this.instanceId(model.instanceId);
            this.name(model.name);
            this.description(model.description);
            this.contactFlowId(model.contactFlowId);
            this.selfAssignFlowId(model.selfAssignFlowId);
            this.constraints(model.constraints);
            this.defaults(model.defaults);
            this.status(model.status);
            this.fields(model.fields);
        }

        public final String getTaskTemplateId() {
            return this.taskTemplateId;
        }

        public final void setTaskTemplateId(String taskTemplateId) {
            this.taskTemplateId = taskTemplateId;
        }

        @Override
        public final Builder taskTemplateId(String taskTemplateId) {
            this.taskTemplateId = taskTemplateId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getContactFlowId() {
            return this.contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final String getSelfAssignFlowId() {
            return this.selfAssignFlowId;
        }

        public final void setSelfAssignFlowId(String selfAssignFlowId) {
            this.selfAssignFlowId = selfAssignFlowId;
        }

        @Override
        public final Builder selfAssignFlowId(String selfAssignFlowId) {
            this.selfAssignFlowId = selfAssignFlowId;
            return this;
        }

        public final TaskTemplateConstraints.Builder getConstraints() {
            return this.constraints != null ? this.constraints.toBuilder() : null;
        }

        public final void setConstraints(TaskTemplateConstraints.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        @Override
        public final Builder constraints(TaskTemplateConstraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public final TaskTemplateDefaults.Builder getDefaults() {
            return this.defaults != null ? this.defaults.toBuilder() : null;
        }

        public final void setDefaults(TaskTemplateDefaults.BuilderImpl defaults) {
            this.defaults = defaults != null ? defaults.build() : null;
        }

        @Override
        public final Builder defaults(TaskTemplateDefaults defaults) {
            this.defaults = defaults;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskTemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<TaskTemplateField.Builder> getFields() {
            List<TaskTemplateField.Builder> result = TaskTemplateFieldsCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<TaskTemplateField.BuilderImpl> fields) {
            this.fields = TaskTemplateFieldsCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<TaskTemplateField> fields) {
            this.fields = TaskTemplateFieldsCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(TaskTemplateField ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<TaskTemplateField.Builder> ... fields) {
            this.fields(Stream.of(fields).map(c -> (TaskTemplateField)((TaskTemplateField.Builder)TaskTemplateField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTaskTemplateRequest build() {
            return new UpdateTaskTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTaskTemplateRequest> {
        public Builder taskTemplateId(String var1);

        public Builder instanceId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder contactFlowId(String var1);

        public Builder selfAssignFlowId(String var1);

        public Builder constraints(TaskTemplateConstraints var1);

        default public Builder constraints(Consumer<TaskTemplateConstraints.Builder> constraints) {
            return this.constraints((TaskTemplateConstraints)((TaskTemplateConstraints.Builder)TaskTemplateConstraints.builder().applyMutation(constraints)).build());
        }

        public Builder defaults(TaskTemplateDefaults var1);

        default public Builder defaults(Consumer<TaskTemplateDefaults.Builder> defaults) {
            return this.defaults((TaskTemplateDefaults)((TaskTemplateDefaults.Builder)TaskTemplateDefaults.builder().applyMutation(defaults)).build());
        }

        public Builder status(String var1);

        public Builder status(TaskTemplateStatus var1);

        public Builder fields(Collection<TaskTemplateField> var1);

        public Builder fields(TaskTemplateField ... var1);

        public Builder fields(Consumer<TaskTemplateField.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

