/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.Expiry;
import software.amazon.awssdk.services.connect.model.Expression;
import software.amazon.awssdk.services.connect.model.RoutingCriteriaStepStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Step
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Step> {
    private static final SdkField<Expiry> EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Expiry").getter(Step.getter(Step::expiry)).setter(Step.setter(Builder::expiry)).constructor(Expiry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiry").build()}).build();
    private static final SdkField<Expression> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Expression").getter(Step.getter(Step::expression)).setter(Step.setter(Builder::expression)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Step.getter(Step::statusAsString)).setter(Step.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRY_FIELD, EXPRESSION_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Step.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Expiry expiry;
    private final Expression expression;
    private final String status;

    private Step(BuilderImpl builder) {
        this.expiry = builder.expiry;
        this.expression = builder.expression;
        this.status = builder.status;
    }

    public final Expiry expiry() {
        return this.expiry;
    }

    public final Expression expression() {
        return this.expression;
    }

    public final RoutingCriteriaStepStatus status() {
        return RoutingCriteriaStepStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expiry());
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Step)) {
            return false;
        }
        Step other = (Step)obj;
        return Objects.equals(this.expiry(), other.expiry()) && Objects.equals(this.expression(), other.expression()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Step").add("Expiry", (Object)this.expiry()).add("Expression", (Object)this.expression()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Expiry": {
                return Optional.ofNullable(clazz.cast(this.expiry()));
            }
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Expiry", EXPIRY_FIELD);
        map.put("Expression", EXPRESSION_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Step, T> g) {
        return obj -> g.apply((Step)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Expiry expiry;
        private Expression expression;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Step model) {
            this.expiry(model.expiry);
            this.expression(model.expression);
            this.status(model.status);
        }

        public final Expiry.Builder getExpiry() {
            return this.expiry != null ? this.expiry.toBuilder() : null;
        }

        public final void setExpiry(Expiry.BuilderImpl expiry) {
            this.expiry = expiry != null ? expiry.build() : null;
        }

        @Override
        public final Builder expiry(Expiry expiry) {
            this.expiry = expiry;
            return this;
        }

        public final Expression.Builder getExpression() {
            return this.expression != null ? this.expression.toBuilder() : null;
        }

        public final void setExpression(Expression.BuilderImpl expression) {
            this.expression = expression != null ? expression.build() : null;
        }

        @Override
        public final Builder expression(Expression expression) {
            this.expression = expression;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RoutingCriteriaStepStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public Step build() {
            return new Step(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Step> {
        public Builder expiry(Expiry var1);

        default public Builder expiry(Consumer<Expiry.Builder> expiry) {
            return this.expiry((Expiry)((Expiry.Builder)Expiry.builder().applyMutation(expiry)).build());
        }

        public Builder expression(Expression var1);

        default public Builder expression(Consumer<Expression.Builder> expression) {
            return this.expression((Expression)((Expression.Builder)Expression.builder().applyMutation(expression)).build());
        }

        public Builder status(String var1);

        public Builder status(RoutingCriteriaStepStatus var1);
    }
}

