/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.QuickConnectConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateQuickConnectConfigRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateQuickConnectConfigRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateQuickConnectConfigRequest.getter(UpdateQuickConnectConfigRequest::instanceId)).setter(UpdateQuickConnectConfigRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> QUICK_CONNECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuickConnectId").getter(UpdateQuickConnectConfigRequest.getter(UpdateQuickConnectConfigRequest::quickConnectId)).setter(UpdateQuickConnectConfigRequest.setter(Builder::quickConnectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("QuickConnectId").build()}).build();
    private static final SdkField<QuickConnectConfig> QUICK_CONNECT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QuickConnectConfig").getter(UpdateQuickConnectConfigRequest.getter(UpdateQuickConnectConfigRequest::quickConnectConfig)).setter(UpdateQuickConnectConfigRequest.setter(Builder::quickConnectConfig)).constructor(QuickConnectConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, QUICK_CONNECT_ID_FIELD, QUICK_CONNECT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateQuickConnectConfigRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String quickConnectId;
    private final QuickConnectConfig quickConnectConfig;

    private UpdateQuickConnectConfigRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.quickConnectId = builder.quickConnectId;
        this.quickConnectConfig = builder.quickConnectConfig;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String quickConnectId() {
        return this.quickConnectId;
    }

    public final QuickConnectConfig quickConnectConfig() {
        return this.quickConnectConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.quickConnectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.quickConnectConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQuickConnectConfigRequest)) {
            return false;
        }
        UpdateQuickConnectConfigRequest other = (UpdateQuickConnectConfigRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.quickConnectId(), other.quickConnectId()) && Objects.equals(this.quickConnectConfig(), other.quickConnectConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateQuickConnectConfigRequest").add("InstanceId", (Object)this.instanceId()).add("QuickConnectId", (Object)this.quickConnectId()).add("QuickConnectConfig", (Object)this.quickConnectConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "QuickConnectId": {
                return Optional.ofNullable(clazz.cast(this.quickConnectId()));
            }
            case "QuickConnectConfig": {
                return Optional.ofNullable(clazz.cast(this.quickConnectConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("QuickConnectId", QUICK_CONNECT_ID_FIELD);
        map.put("QuickConnectConfig", QUICK_CONNECT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQuickConnectConfigRequest, T> g) {
        return obj -> g.apply((UpdateQuickConnectConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String quickConnectId;
        private QuickConnectConfig quickConnectConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQuickConnectConfigRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.quickConnectId(model.quickConnectId);
            this.quickConnectConfig(model.quickConnectConfig);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getQuickConnectId() {
            return this.quickConnectId;
        }

        public final void setQuickConnectId(String quickConnectId) {
            this.quickConnectId = quickConnectId;
        }

        @Override
        public final Builder quickConnectId(String quickConnectId) {
            this.quickConnectId = quickConnectId;
            return this;
        }

        public final QuickConnectConfig.Builder getQuickConnectConfig() {
            return this.quickConnectConfig != null ? this.quickConnectConfig.toBuilder() : null;
        }

        public final void setQuickConnectConfig(QuickConnectConfig.BuilderImpl quickConnectConfig) {
            this.quickConnectConfig = quickConnectConfig != null ? quickConnectConfig.build() : null;
        }

        @Override
        public final Builder quickConnectConfig(QuickConnectConfig quickConnectConfig) {
            this.quickConnectConfig = quickConnectConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQuickConnectConfigRequest build() {
            return new UpdateQuickConnectConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateQuickConnectConfigRequest> {
        public Builder instanceId(String var1);

        public Builder quickConnectId(String var1);

        public Builder quickConnectConfig(QuickConnectConfig var1);

        default public Builder quickConnectConfig(Consumer<QuickConnectConfig.Builder> quickConnectConfig) {
            return this.quickConnectConfig((QuickConnectConfig)((QuickConnectConfig.Builder)QuickConnectConfig.builder().applyMutation(quickConnectConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

