/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.PredefinedAttribute;
import software.amazon.awssdk.services.connect.model.PredefinedAttributeSearchSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchPredefinedAttributesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, SearchPredefinedAttributesResponse> {
    private static final SdkField<List<PredefinedAttribute>> PREDEFINED_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PredefinedAttributes").getter(SearchPredefinedAttributesResponse.getter(SearchPredefinedAttributesResponse::predefinedAttributes)).setter(SearchPredefinedAttributesResponse.setter(Builder::predefinedAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PredefinedAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchPredefinedAttributesResponse.getter(SearchPredefinedAttributesResponse::nextToken)).setter(SearchPredefinedAttributesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateTotalCount").getter(SearchPredefinedAttributesResponse.getter(SearchPredefinedAttributesResponse::approximateTotalCount)).setter(SearchPredefinedAttributesResponse.setter(Builder::approximateTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDEFINED_ATTRIBUTES_FIELD, NEXT_TOKEN_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchPredefinedAttributesResponse.memberNameToFieldInitializer();
    private final List<PredefinedAttribute> predefinedAttributes;
    private final String nextToken;
    private final Long approximateTotalCount;

    private SearchPredefinedAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.predefinedAttributes = builder.predefinedAttributes;
        this.nextToken = builder.nextToken;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    public final boolean hasPredefinedAttributes() {
        return this.predefinedAttributes != null && !(this.predefinedAttributes instanceof SdkAutoConstructList);
    }

    public final List<PredefinedAttribute> predefinedAttributes() {
        return this.predefinedAttributes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long approximateTotalCount() {
        return this.approximateTotalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPredefinedAttributes() ? this.predefinedAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTotalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPredefinedAttributesResponse)) {
            return false;
        }
        SearchPredefinedAttributesResponse other = (SearchPredefinedAttributesResponse)((Object)obj);
        return this.hasPredefinedAttributes() == other.hasPredefinedAttributes() && Objects.equals(this.predefinedAttributes(), other.predefinedAttributes()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.approximateTotalCount(), other.approximateTotalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchPredefinedAttributesResponse").add("PredefinedAttributes", this.hasPredefinedAttributes() ? this.predefinedAttributes() : null).add("NextToken", (Object)this.nextToken()).add("ApproximateTotalCount", (Object)this.approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PredefinedAttributes": {
                return Optional.ofNullable(clazz.cast(this.predefinedAttributes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ApproximateTotalCount": {
                return Optional.ofNullable(clazz.cast(this.approximateTotalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PredefinedAttributes", PREDEFINED_ATTRIBUTES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchPredefinedAttributesResponse, T> g) {
        return obj -> g.apply((SearchPredefinedAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<PredefinedAttribute> predefinedAttributes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPredefinedAttributesResponse model) {
            super(model);
            this.predefinedAttributes(model.predefinedAttributes);
            this.nextToken(model.nextToken);
            this.approximateTotalCount(model.approximateTotalCount);
        }

        public final List<PredefinedAttribute.Builder> getPredefinedAttributes() {
            List<PredefinedAttribute.Builder> result = PredefinedAttributeSearchSummaryListCopier.copyToBuilder(this.predefinedAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPredefinedAttributes(Collection<PredefinedAttribute.BuilderImpl> predefinedAttributes) {
            this.predefinedAttributes = PredefinedAttributeSearchSummaryListCopier.copyFromBuilder(predefinedAttributes);
        }

        @Override
        public final Builder predefinedAttributes(Collection<PredefinedAttribute> predefinedAttributes) {
            this.predefinedAttributes = PredefinedAttributeSearchSummaryListCopier.copy(predefinedAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predefinedAttributes(PredefinedAttribute ... predefinedAttributes) {
            this.predefinedAttributes(Arrays.asList(predefinedAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predefinedAttributes(Consumer<PredefinedAttribute.Builder> ... predefinedAttributes) {
            this.predefinedAttributes(Stream.of(predefinedAttributes).map(c -> (PredefinedAttribute)((PredefinedAttribute.Builder)PredefinedAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getApproximateTotalCount() {
            return this.approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchPredefinedAttributesResponse build() {
            return new SearchPredefinedAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchPredefinedAttributesResponse> {
        public Builder predefinedAttributes(Collection<PredefinedAttribute> var1);

        public Builder predefinedAttributes(PredefinedAttribute ... var1);

        public Builder predefinedAttributes(Consumer<PredefinedAttribute.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder approximateTotalCount(Long var1);
    }
}

