/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateParticipantAuthenticationRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateParticipantAuthenticationRequest> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(UpdateParticipantAuthenticationRequest.getter(UpdateParticipantAuthenticationRequest::state)).setter(UpdateParticipantAuthenticationRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateParticipantAuthenticationRequest.getter(UpdateParticipantAuthenticationRequest::instanceId)).setter(UpdateParticipantAuthenticationRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Code").getter(UpdateParticipantAuthenticationRequest.getter(UpdateParticipantAuthenticationRequest::code)).setter(UpdateParticipantAuthenticationRequest.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Error").getter(UpdateParticipantAuthenticationRequest.getter(UpdateParticipantAuthenticationRequest::error)).setter(UpdateParticipantAuthenticationRequest.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<String> ERROR_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorDescription").getter(UpdateParticipantAuthenticationRequest.getter(UpdateParticipantAuthenticationRequest::errorDescription)).setter(UpdateParticipantAuthenticationRequest.setter(Builder::errorDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, INSTANCE_ID_FIELD, CODE_FIELD, ERROR_FIELD, ERROR_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateParticipantAuthenticationRequest.memberNameToFieldInitializer();
    private final String state;
    private final String instanceId;
    private final String code;
    private final String error;
    private final String errorDescription;

    private UpdateParticipantAuthenticationRequest(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
        this.instanceId = builder.instanceId;
        this.code = builder.code;
        this.error = builder.error;
        this.errorDescription = builder.errorDescription;
    }

    public final String state() {
        return this.state;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String code() {
        return this.code;
    }

    public final String error() {
        return this.error;
    }

    public final String errorDescription() {
        return this.errorDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateParticipantAuthenticationRequest)) {
            return false;
        }
        UpdateParticipantAuthenticationRequest other = (UpdateParticipantAuthenticationRequest)((Object)obj);
        return Objects.equals(this.state(), other.state()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.errorDescription(), other.errorDescription());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateParticipantAuthenticationRequest").add("State", (Object)this.state()).add("InstanceId", (Object)this.instanceId()).add("Code", (Object)(this.code() == null ? null : "*** Sensitive Data Redacted ***")).add("Error", (Object)(this.error() == null ? null : "*** Sensitive Data Redacted ***")).add("ErrorDescription", (Object)(this.errorDescription() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "ErrorDescription": {
                return Optional.ofNullable(clazz.cast(this.errorDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("State", STATE_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Code", CODE_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("ErrorDescription", ERROR_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateParticipantAuthenticationRequest, T> g) {
        return obj -> g.apply((UpdateParticipantAuthenticationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String state;
        private String instanceId;
        private String code;
        private String error;
        private String errorDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateParticipantAuthenticationRequest model) {
            super(model);
            this.state(model.state);
            this.instanceId(model.instanceId);
            this.code(model.code);
            this.error(model.error);
            this.errorDescription(model.errorDescription);
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getErrorDescription() {
            return this.errorDescription;
        }

        public final void setErrorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
        }

        @Override
        public final Builder errorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateParticipantAuthenticationRequest build() {
            return new UpdateParticipantAuthenticationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateParticipantAuthenticationRequest> {
        public Builder state(String var1);

        public Builder instanceId(String var1);

        public Builder code(String var1);

        public Builder error(String var1);

        public Builder errorDescription(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

