/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.EvaluationFormQuestionType;
import software.amazon.awssdk.services.connect.model.EvaluationFormQuestionTypeProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationFormQuestion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationFormQuestion> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(EvaluationFormQuestion.getter(EvaluationFormQuestion::title)).setter(EvaluationFormQuestion.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> INSTRUCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Instructions").getter(EvaluationFormQuestion.getter(EvaluationFormQuestion::instructions)).setter(EvaluationFormQuestion.setter(Builder::instructions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instructions").build()}).build();
    private static final SdkField<String> REF_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RefId").getter(EvaluationFormQuestion.getter(EvaluationFormQuestion::refId)).setter(EvaluationFormQuestion.setter(Builder::refId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefId").build()}).build();
    private static final SdkField<Boolean> NOT_APPLICABLE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NotApplicableEnabled").getter(EvaluationFormQuestion.getter(EvaluationFormQuestion::notApplicableEnabled)).setter(EvaluationFormQuestion.setter(Builder::notApplicableEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotApplicableEnabled").build()}).build();
    private static final SdkField<String> QUESTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionType").getter(EvaluationFormQuestion.getter(EvaluationFormQuestion::questionTypeAsString)).setter(EvaluationFormQuestion.setter(Builder::questionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionType").build()}).build();
    private static final SdkField<EvaluationFormQuestionTypeProperties> QUESTION_TYPE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QuestionTypeProperties").getter(EvaluationFormQuestion.getter(EvaluationFormQuestion::questionTypeProperties)).setter(EvaluationFormQuestion.setter(Builder::questionTypeProperties)).constructor(EvaluationFormQuestionTypeProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionTypeProperties").build()}).build();
    private static final SdkField<Double> WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Weight").getter(EvaluationFormQuestion.getter(EvaluationFormQuestion::weight)).setter(EvaluationFormQuestion.setter(Builder::weight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, INSTRUCTIONS_FIELD, REF_ID_FIELD, NOT_APPLICABLE_ENABLED_FIELD, QUESTION_TYPE_FIELD, QUESTION_TYPE_PROPERTIES_FIELD, WEIGHT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationFormQuestion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String instructions;
    private final String refId;
    private final Boolean notApplicableEnabled;
    private final String questionType;
    private final EvaluationFormQuestionTypeProperties questionTypeProperties;
    private final Double weight;

    private EvaluationFormQuestion(BuilderImpl builder) {
        this.title = builder.title;
        this.instructions = builder.instructions;
        this.refId = builder.refId;
        this.notApplicableEnabled = builder.notApplicableEnabled;
        this.questionType = builder.questionType;
        this.questionTypeProperties = builder.questionTypeProperties;
        this.weight = builder.weight;
    }

    public final String title() {
        return this.title;
    }

    public final String instructions() {
        return this.instructions;
    }

    public final String refId() {
        return this.refId;
    }

    public final Boolean notApplicableEnabled() {
        return this.notApplicableEnabled;
    }

    public final EvaluationFormQuestionType questionType() {
        return EvaluationFormQuestionType.fromValue(this.questionType);
    }

    public final String questionTypeAsString() {
        return this.questionType;
    }

    public final EvaluationFormQuestionTypeProperties questionTypeProperties() {
        return this.questionTypeProperties;
    }

    public final Double weight() {
        return this.weight;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.instructions());
        hashCode = 31 * hashCode + Objects.hashCode(this.refId());
        hashCode = 31 * hashCode + Objects.hashCode(this.notApplicableEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionTypeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.weight());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormQuestion)) {
            return false;
        }
        EvaluationFormQuestion other = (EvaluationFormQuestion)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.instructions(), other.instructions()) && Objects.equals(this.refId(), other.refId()) && Objects.equals(this.notApplicableEnabled(), other.notApplicableEnabled()) && Objects.equals(this.questionTypeAsString(), other.questionTypeAsString()) && Objects.equals(this.questionTypeProperties(), other.questionTypeProperties()) && Objects.equals(this.weight(), other.weight());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationFormQuestion").add("Title", (Object)this.title()).add("Instructions", (Object)this.instructions()).add("RefId", (Object)this.refId()).add("NotApplicableEnabled", (Object)this.notApplicableEnabled()).add("QuestionType", (Object)this.questionTypeAsString()).add("QuestionTypeProperties", (Object)this.questionTypeProperties()).add("Weight", (Object)this.weight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Instructions": {
                return Optional.ofNullable(clazz.cast(this.instructions()));
            }
            case "RefId": {
                return Optional.ofNullable(clazz.cast(this.refId()));
            }
            case "NotApplicableEnabled": {
                return Optional.ofNullable(clazz.cast(this.notApplicableEnabled()));
            }
            case "QuestionType": {
                return Optional.ofNullable(clazz.cast(this.questionTypeAsString()));
            }
            case "QuestionTypeProperties": {
                return Optional.ofNullable(clazz.cast(this.questionTypeProperties()));
            }
            case "Weight": {
                return Optional.ofNullable(clazz.cast(this.weight()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Title", TITLE_FIELD);
        map.put("Instructions", INSTRUCTIONS_FIELD);
        map.put("RefId", REF_ID_FIELD);
        map.put("NotApplicableEnabled", NOT_APPLICABLE_ENABLED_FIELD);
        map.put("QuestionType", QUESTION_TYPE_FIELD);
        map.put("QuestionTypeProperties", QUESTION_TYPE_PROPERTIES_FIELD);
        map.put("Weight", WEIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormQuestion, T> g) {
        return obj -> g.apply((EvaluationFormQuestion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private String instructions;
        private String refId;
        private Boolean notApplicableEnabled;
        private String questionType;
        private EvaluationFormQuestionTypeProperties questionTypeProperties;
        private Double weight;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormQuestion model) {
            this.title(model.title);
            this.instructions(model.instructions);
            this.refId(model.refId);
            this.notApplicableEnabled(model.notApplicableEnabled);
            this.questionType(model.questionType);
            this.questionTypeProperties(model.questionTypeProperties);
            this.weight(model.weight);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getInstructions() {
            return this.instructions;
        }

        public final void setInstructions(String instructions) {
            this.instructions = instructions;
        }

        @Override
        public final Builder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public final String getRefId() {
            return this.refId;
        }

        public final void setRefId(String refId) {
            this.refId = refId;
        }

        @Override
        public final Builder refId(String refId) {
            this.refId = refId;
            return this;
        }

        public final Boolean getNotApplicableEnabled() {
            return this.notApplicableEnabled;
        }

        public final void setNotApplicableEnabled(Boolean notApplicableEnabled) {
            this.notApplicableEnabled = notApplicableEnabled;
        }

        @Override
        public final Builder notApplicableEnabled(Boolean notApplicableEnabled) {
            this.notApplicableEnabled = notApplicableEnabled;
            return this;
        }

        public final String getQuestionType() {
            return this.questionType;
        }

        public final void setQuestionType(String questionType) {
            this.questionType = questionType;
        }

        @Override
        public final Builder questionType(String questionType) {
            this.questionType = questionType;
            return this;
        }

        @Override
        public final Builder questionType(EvaluationFormQuestionType questionType) {
            this.questionType(questionType == null ? null : questionType.toString());
            return this;
        }

        public final EvaluationFormQuestionTypeProperties.Builder getQuestionTypeProperties() {
            return this.questionTypeProperties != null ? this.questionTypeProperties.toBuilder() : null;
        }

        public final void setQuestionTypeProperties(EvaluationFormQuestionTypeProperties.BuilderImpl questionTypeProperties) {
            this.questionTypeProperties = questionTypeProperties != null ? questionTypeProperties.build() : null;
        }

        @Override
        public final Builder questionTypeProperties(EvaluationFormQuestionTypeProperties questionTypeProperties) {
            this.questionTypeProperties = questionTypeProperties;
            return this;
        }

        public final Double getWeight() {
            return this.weight;
        }

        public final void setWeight(Double weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Double weight) {
            this.weight = weight;
            return this;
        }

        public EvaluationFormQuestion build() {
            return new EvaluationFormQuestion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationFormQuestion> {
        public Builder title(String var1);

        public Builder instructions(String var1);

        public Builder refId(String var1);

        public Builder notApplicableEnabled(Boolean var1);

        public Builder questionType(String var1);

        public Builder questionType(EvaluationFormQuestionType var1);

        public Builder questionTypeProperties(EvaluationFormQuestionTypeProperties var1);

        default public Builder questionTypeProperties(Consumer<EvaluationFormQuestionTypeProperties.Builder> questionTypeProperties) {
            return this.questionTypeProperties((EvaluationFormQuestionTypeProperties)((EvaluationFormQuestionTypeProperties.Builder)EvaluationFormQuestionTypeProperties.builder().applyMutation(questionTypeProperties)).build());
        }

        public Builder weight(Double var1);
    }
}

