/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHoursOfOperationOverrideRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, DescribeHoursOfOperationOverrideRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(DescribeHoursOfOperationOverrideRequest.getter(DescribeHoursOfOperationOverrideRequest::instanceId)).setter(DescribeHoursOfOperationOverrideRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> HOURS_OF_OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HoursOfOperationId").getter(DescribeHoursOfOperationOverrideRequest.getter(DescribeHoursOfOperationOverrideRequest::hoursOfOperationId)).setter(DescribeHoursOfOperationOverrideRequest.setter(Builder::hoursOfOperationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("HoursOfOperationId").build()}).build();
    private static final SdkField<String> HOURS_OF_OPERATION_OVERRIDE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HoursOfOperationOverrideId").getter(DescribeHoursOfOperationOverrideRequest.getter(DescribeHoursOfOperationOverrideRequest::hoursOfOperationOverrideId)).setter(DescribeHoursOfOperationOverrideRequest.setter(Builder::hoursOfOperationOverrideId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("HoursOfOperationOverrideId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, HOURS_OF_OPERATION_ID_FIELD, HOURS_OF_OPERATION_OVERRIDE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeHoursOfOperationOverrideRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String hoursOfOperationId;
    private final String hoursOfOperationOverrideId;

    private DescribeHoursOfOperationOverrideRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.hoursOfOperationId = builder.hoursOfOperationId;
        this.hoursOfOperationOverrideId = builder.hoursOfOperationOverrideId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String hoursOfOperationId() {
        return this.hoursOfOperationId;
    }

    public final String hoursOfOperationOverrideId() {
        return this.hoursOfOperationOverrideId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hoursOfOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hoursOfOperationOverrideId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHoursOfOperationOverrideRequest)) {
            return false;
        }
        DescribeHoursOfOperationOverrideRequest other = (DescribeHoursOfOperationOverrideRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.hoursOfOperationId(), other.hoursOfOperationId()) && Objects.equals(this.hoursOfOperationOverrideId(), other.hoursOfOperationOverrideId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeHoursOfOperationOverrideRequest").add("InstanceId", (Object)this.instanceId()).add("HoursOfOperationId", (Object)this.hoursOfOperationId()).add("HoursOfOperationOverrideId", (Object)this.hoursOfOperationOverrideId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "HoursOfOperationId": {
                return Optional.ofNullable(clazz.cast(this.hoursOfOperationId()));
            }
            case "HoursOfOperationOverrideId": {
                return Optional.ofNullable(clazz.cast(this.hoursOfOperationOverrideId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("HoursOfOperationId", HOURS_OF_OPERATION_ID_FIELD);
        map.put("HoursOfOperationOverrideId", HOURS_OF_OPERATION_OVERRIDE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeHoursOfOperationOverrideRequest, T> g) {
        return obj -> g.apply((DescribeHoursOfOperationOverrideRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String hoursOfOperationId;
        private String hoursOfOperationOverrideId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHoursOfOperationOverrideRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.hoursOfOperationId(model.hoursOfOperationId);
            this.hoursOfOperationOverrideId(model.hoursOfOperationOverrideId);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getHoursOfOperationId() {
            return this.hoursOfOperationId;
        }

        public final void setHoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
        }

        @Override
        public final Builder hoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
            return this;
        }

        public final String getHoursOfOperationOverrideId() {
            return this.hoursOfOperationOverrideId;
        }

        public final void setHoursOfOperationOverrideId(String hoursOfOperationOverrideId) {
            this.hoursOfOperationOverrideId = hoursOfOperationOverrideId;
        }

        @Override
        public final Builder hoursOfOperationOverrideId(String hoursOfOperationOverrideId) {
            this.hoursOfOperationOverrideId = hoursOfOperationOverrideId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeHoursOfOperationOverrideRequest build() {
            return new DescribeHoursOfOperationOverrideRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHoursOfOperationOverrideRequest> {
        public Builder instanceId(String var1);

        public Builder hoursOfOperationId(String var1);

        public Builder hoursOfOperationOverrideId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

