/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AllowedCapabilities;
import software.amazon.awssdk.services.connect.model.AttributesCopier;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.ContactReferencesCopier;
import software.amazon.awssdk.services.connect.model.ParticipantDetails;
import software.amazon.awssdk.services.connect.model.Reference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartWebRtcContactRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, StartWebRtcContactRequest> {
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(StartWebRtcContactRequest.getter(StartWebRtcContactRequest::attributes)).setter(StartWebRtcContactRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartWebRtcContactRequest.getter(StartWebRtcContactRequest::clientToken)).setter(StartWebRtcContactRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactFlowId").getter(StartWebRtcContactRequest.getter(StartWebRtcContactRequest::contactFlowId)).setter(StartWebRtcContactRequest.setter(Builder::contactFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(StartWebRtcContactRequest.getter(StartWebRtcContactRequest::instanceId)).setter(StartWebRtcContactRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<AllowedCapabilities> ALLOWED_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AllowedCapabilities").getter(StartWebRtcContactRequest.getter(StartWebRtcContactRequest::allowedCapabilities)).setter(StartWebRtcContactRequest.setter(Builder::allowedCapabilities)).constructor(AllowedCapabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedCapabilities").build()}).build();
    private static final SdkField<ParticipantDetails> PARTICIPANT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParticipantDetails").getter(StartWebRtcContactRequest.getter(StartWebRtcContactRequest::participantDetails)).setter(StartWebRtcContactRequest.setter(Builder::participantDetails)).constructor(ParticipantDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantDetails").build()}).build();
    private static final SdkField<String> RELATED_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelatedContactId").getter(StartWebRtcContactRequest.getter(StartWebRtcContactRequest::relatedContactId)).setter(StartWebRtcContactRequest.setter(Builder::relatedContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedContactId").build()}).build();
    private static final SdkField<Map<String, Reference>> REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("References").getter(StartWebRtcContactRequest.getter(StartWebRtcContactRequest::references)).setter(StartWebRtcContactRequest.setter(Builder::references)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("References").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Reference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StartWebRtcContactRequest.getter(StartWebRtcContactRequest::description)).setter(StartWebRtcContactRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, CLIENT_TOKEN_FIELD, CONTACT_FLOW_ID_FIELD, INSTANCE_ID_FIELD, ALLOWED_CAPABILITIES_FIELD, PARTICIPANT_DETAILS_FIELD, RELATED_CONTACT_ID_FIELD, REFERENCES_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartWebRtcContactRequest.memberNameToFieldInitializer();
    private final Map<String, String> attributes;
    private final String clientToken;
    private final String contactFlowId;
    private final String instanceId;
    private final AllowedCapabilities allowedCapabilities;
    private final ParticipantDetails participantDetails;
    private final String relatedContactId;
    private final Map<String, Reference> references;
    private final String description;

    private StartWebRtcContactRequest(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
        this.clientToken = builder.clientToken;
        this.contactFlowId = builder.contactFlowId;
        this.instanceId = builder.instanceId;
        this.allowedCapabilities = builder.allowedCapabilities;
        this.participantDetails = builder.participantDetails;
        this.relatedContactId = builder.relatedContactId;
        this.references = builder.references;
        this.description = builder.description;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String contactFlowId() {
        return this.contactFlowId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final AllowedCapabilities allowedCapabilities() {
        return this.allowedCapabilities;
    }

    public final ParticipantDetails participantDetails() {
        return this.participantDetails;
    }

    public final String relatedContactId() {
        return this.relatedContactId;
    }

    public final boolean hasReferences() {
        return this.references != null && !(this.references instanceof SdkAutoConstructMap);
    }

    public final Map<String, Reference> references() {
        return this.references;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedCapabilities());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferences() ? this.references() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartWebRtcContactRequest)) {
            return false;
        }
        StartWebRtcContactRequest other = (StartWebRtcContactRequest)((Object)obj);
        return this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.contactFlowId(), other.contactFlowId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.allowedCapabilities(), other.allowedCapabilities()) && Objects.equals(this.participantDetails(), other.participantDetails()) && Objects.equals(this.relatedContactId(), other.relatedContactId()) && this.hasReferences() == other.hasReferences() && Objects.equals(this.references(), other.references()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"StartWebRtcContactRequest").add("Attributes", this.hasAttributes() ? this.attributes() : null).add("ClientToken", (Object)this.clientToken()).add("ContactFlowId", (Object)this.contactFlowId()).add("InstanceId", (Object)this.instanceId()).add("AllowedCapabilities", (Object)this.allowedCapabilities()).add("ParticipantDetails", (Object)this.participantDetails()).add("RelatedContactId", (Object)this.relatedContactId()).add("References", this.hasReferences() ? this.references() : null).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ContactFlowId": {
                return Optional.ofNullable(clazz.cast(this.contactFlowId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "AllowedCapabilities": {
                return Optional.ofNullable(clazz.cast(this.allowedCapabilities()));
            }
            case "ParticipantDetails": {
                return Optional.ofNullable(clazz.cast(this.participantDetails()));
            }
            case "RelatedContactId": {
                return Optional.ofNullable(clazz.cast(this.relatedContactId()));
            }
            case "References": {
                return Optional.ofNullable(clazz.cast(this.references()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ContactFlowId", CONTACT_FLOW_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("AllowedCapabilities", ALLOWED_CAPABILITIES_FIELD);
        map.put("ParticipantDetails", PARTICIPANT_DETAILS_FIELD);
        map.put("RelatedContactId", RELATED_CONTACT_ID_FIELD);
        map.put("References", REFERENCES_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartWebRtcContactRequest, T> g) {
        return obj -> g.apply((StartWebRtcContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;
        private String contactFlowId;
        private String instanceId;
        private AllowedCapabilities allowedCapabilities;
        private ParticipantDetails participantDetails;
        private String relatedContactId;
        private Map<String, Reference> references = DefaultSdkAutoConstructMap.getInstance();
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(StartWebRtcContactRequest model) {
            super(model);
            this.attributes(model.attributes);
            this.clientToken(model.clientToken);
            this.contactFlowId(model.contactFlowId);
            this.instanceId(model.instanceId);
            this.allowedCapabilities(model.allowedCapabilities);
            this.participantDetails(model.participantDetails);
            this.relatedContactId(model.relatedContactId);
            this.references(model.references);
            this.description(model.description);
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getContactFlowId() {
            return this.contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final AllowedCapabilities.Builder getAllowedCapabilities() {
            return this.allowedCapabilities != null ? this.allowedCapabilities.toBuilder() : null;
        }

        public final void setAllowedCapabilities(AllowedCapabilities.BuilderImpl allowedCapabilities) {
            this.allowedCapabilities = allowedCapabilities != null ? allowedCapabilities.build() : null;
        }

        @Override
        public final Builder allowedCapabilities(AllowedCapabilities allowedCapabilities) {
            this.allowedCapabilities = allowedCapabilities;
            return this;
        }

        public final ParticipantDetails.Builder getParticipantDetails() {
            return this.participantDetails != null ? this.participantDetails.toBuilder() : null;
        }

        public final void setParticipantDetails(ParticipantDetails.BuilderImpl participantDetails) {
            this.participantDetails = participantDetails != null ? participantDetails.build() : null;
        }

        @Override
        public final Builder participantDetails(ParticipantDetails participantDetails) {
            this.participantDetails = participantDetails;
            return this;
        }

        public final String getRelatedContactId() {
            return this.relatedContactId;
        }

        public final void setRelatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
        }

        @Override
        public final Builder relatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
            return this;
        }

        public final Map<String, Reference.Builder> getReferences() {
            Map<String, Reference.Builder> result = ContactReferencesCopier.copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setReferences(Map<String, Reference.BuilderImpl> references) {
            this.references = ContactReferencesCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Map<String, Reference> references) {
            this.references = ContactReferencesCopier.copy(references);
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartWebRtcContactRequest build() {
            return new StartWebRtcContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartWebRtcContactRequest> {
        public Builder attributes(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder contactFlowId(String var1);

        public Builder instanceId(String var1);

        public Builder allowedCapabilities(AllowedCapabilities var1);

        default public Builder allowedCapabilities(Consumer<AllowedCapabilities.Builder> allowedCapabilities) {
            return this.allowedCapabilities((AllowedCapabilities)((AllowedCapabilities.Builder)AllowedCapabilities.builder().applyMutation(allowedCapabilities)).build());
        }

        public Builder participantDetails(ParticipantDetails var1);

        default public Builder participantDetails(Consumer<ParticipantDetails.Builder> participantDetails) {
            return this.participantDetails((ParticipantDetails)((ParticipantDetails.Builder)ParticipantDetails.builder().applyMutation(participantDetails)).build());
        }

        public Builder relatedContactId(String var1);

        public Builder references(Map<String, Reference> var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

