/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisSegmentAttachments;
import software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisSegmentCategories;
import software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisSegmentEvent;
import software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisSegmentIssues;
import software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisSegmentPostContactSummary;
import software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisSegmentTranscript;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RealtimeContactAnalysisSegment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RealtimeContactAnalysisSegment> {
    private static final SdkField<RealTimeContactAnalysisSegmentTranscript> TRANSCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Transcript").getter(RealtimeContactAnalysisSegment.getter(RealtimeContactAnalysisSegment::transcript)).setter(RealtimeContactAnalysisSegment.setter(Builder::transcript)).constructor(RealTimeContactAnalysisSegmentTranscript::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transcript").build()}).build();
    private static final SdkField<RealTimeContactAnalysisSegmentCategories> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Categories").getter(RealtimeContactAnalysisSegment.getter(RealtimeContactAnalysisSegment::categories)).setter(RealtimeContactAnalysisSegment.setter(Builder::categories)).constructor(RealTimeContactAnalysisSegmentCategories::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build()}).build();
    private static final SdkField<RealTimeContactAnalysisSegmentIssues> ISSUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Issues").getter(RealtimeContactAnalysisSegment.getter(RealtimeContactAnalysisSegment::issues)).setter(RealtimeContactAnalysisSegment.setter(Builder::issues)).constructor(RealTimeContactAnalysisSegmentIssues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issues").build()}).build();
    private static final SdkField<RealTimeContactAnalysisSegmentEvent> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Event").getter(RealtimeContactAnalysisSegment.getter(RealtimeContactAnalysisSegment::event)).setter(RealtimeContactAnalysisSegment.setter(Builder::event)).constructor(RealTimeContactAnalysisSegmentEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event").build()}).build();
    private static final SdkField<RealTimeContactAnalysisSegmentAttachments> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attachments").getter(RealtimeContactAnalysisSegment.getter(RealtimeContactAnalysisSegment::attachments)).setter(RealtimeContactAnalysisSegment.setter(Builder::attachments)).constructor(RealTimeContactAnalysisSegmentAttachments::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build()}).build();
    private static final SdkField<RealTimeContactAnalysisSegmentPostContactSummary> POST_CONTACT_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PostContactSummary").getter(RealtimeContactAnalysisSegment.getter(RealtimeContactAnalysisSegment::postContactSummary)).setter(RealtimeContactAnalysisSegment.setter(Builder::postContactSummary)).constructor(RealTimeContactAnalysisSegmentPostContactSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostContactSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FIELD, CATEGORIES_FIELD, ISSUES_FIELD, EVENT_FIELD, ATTACHMENTS_FIELD, POST_CONTACT_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RealtimeContactAnalysisSegment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RealTimeContactAnalysisSegmentTranscript transcript;
    private final RealTimeContactAnalysisSegmentCategories categories;
    private final RealTimeContactAnalysisSegmentIssues issues;
    private final RealTimeContactAnalysisSegmentEvent event;
    private final RealTimeContactAnalysisSegmentAttachments attachments;
    private final RealTimeContactAnalysisSegmentPostContactSummary postContactSummary;
    private final Type type;

    private RealtimeContactAnalysisSegment(BuilderImpl builder) {
        this.transcript = builder.transcript;
        this.categories = builder.categories;
        this.issues = builder.issues;
        this.event = builder.event;
        this.attachments = builder.attachments;
        this.postContactSummary = builder.postContactSummary;
        this.type = builder.type;
    }

    public final RealTimeContactAnalysisSegmentTranscript transcript() {
        return this.transcript;
    }

    public final RealTimeContactAnalysisSegmentCategories categories() {
        return this.categories;
    }

    public final RealTimeContactAnalysisSegmentIssues issues() {
        return this.issues;
    }

    public final RealTimeContactAnalysisSegmentEvent event() {
        return this.event;
    }

    public final RealTimeContactAnalysisSegmentAttachments attachments() {
        return this.attachments;
    }

    public final RealTimeContactAnalysisSegmentPostContactSummary postContactSummary() {
        return this.postContactSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transcript());
        hashCode = 31 * hashCode + Objects.hashCode(this.categories());
        hashCode = 31 * hashCode + Objects.hashCode(this.issues());
        hashCode = 31 * hashCode + Objects.hashCode(this.event());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.postContactSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealtimeContactAnalysisSegment)) {
            return false;
        }
        RealtimeContactAnalysisSegment other = (RealtimeContactAnalysisSegment)obj;
        return Objects.equals(this.transcript(), other.transcript()) && Objects.equals(this.categories(), other.categories()) && Objects.equals(this.issues(), other.issues()) && Objects.equals(this.event(), other.event()) && Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.postContactSummary(), other.postContactSummary());
    }

    public final String toString() {
        return ToString.builder((String)"RealtimeContactAnalysisSegment").add("Transcript", (Object)this.transcript()).add("Categories", (Object)this.categories()).add("Issues", (Object)this.issues()).add("Event", (Object)this.event()).add("Attachments", (Object)this.attachments()).add("PostContactSummary", (Object)this.postContactSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Transcript": {
                return Optional.ofNullable(clazz.cast(this.transcript()));
            }
            case "Categories": {
                return Optional.ofNullable(clazz.cast(this.categories()));
            }
            case "Issues": {
                return Optional.ofNullable(clazz.cast(this.issues()));
            }
            case "Event": {
                return Optional.ofNullable(clazz.cast(this.event()));
            }
            case "Attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "PostContactSummary": {
                return Optional.ofNullable(clazz.cast(this.postContactSummary()));
            }
        }
        return Optional.empty();
    }

    public static RealtimeContactAnalysisSegment fromTranscript(RealTimeContactAnalysisSegmentTranscript transcript) {
        return (RealtimeContactAnalysisSegment)RealtimeContactAnalysisSegment.builder().transcript(transcript).build();
    }

    public static RealtimeContactAnalysisSegment fromTranscript(Consumer<RealTimeContactAnalysisSegmentTranscript.Builder> transcript) {
        RealTimeContactAnalysisSegmentTranscript.Builder builder = RealTimeContactAnalysisSegmentTranscript.builder();
        transcript.accept(builder);
        return RealtimeContactAnalysisSegment.fromTranscript((RealTimeContactAnalysisSegmentTranscript)builder.build());
    }

    public static RealtimeContactAnalysisSegment fromCategories(RealTimeContactAnalysisSegmentCategories categories) {
        return (RealtimeContactAnalysisSegment)RealtimeContactAnalysisSegment.builder().categories(categories).build();
    }

    public static RealtimeContactAnalysisSegment fromCategories(Consumer<RealTimeContactAnalysisSegmentCategories.Builder> categories) {
        RealTimeContactAnalysisSegmentCategories.Builder builder = RealTimeContactAnalysisSegmentCategories.builder();
        categories.accept(builder);
        return RealtimeContactAnalysisSegment.fromCategories((RealTimeContactAnalysisSegmentCategories)builder.build());
    }

    public static RealtimeContactAnalysisSegment fromIssues(RealTimeContactAnalysisSegmentIssues issues) {
        return (RealtimeContactAnalysisSegment)RealtimeContactAnalysisSegment.builder().issues(issues).build();
    }

    public static RealtimeContactAnalysisSegment fromIssues(Consumer<RealTimeContactAnalysisSegmentIssues.Builder> issues) {
        RealTimeContactAnalysisSegmentIssues.Builder builder = RealTimeContactAnalysisSegmentIssues.builder();
        issues.accept(builder);
        return RealtimeContactAnalysisSegment.fromIssues((RealTimeContactAnalysisSegmentIssues)builder.build());
    }

    public static RealtimeContactAnalysisSegment fromEvent(RealTimeContactAnalysisSegmentEvent event) {
        return (RealtimeContactAnalysisSegment)RealtimeContactAnalysisSegment.builder().event(event).build();
    }

    public static RealtimeContactAnalysisSegment fromEvent(Consumer<RealTimeContactAnalysisSegmentEvent.Builder> event) {
        RealTimeContactAnalysisSegmentEvent.Builder builder = RealTimeContactAnalysisSegmentEvent.builder();
        event.accept(builder);
        return RealtimeContactAnalysisSegment.fromEvent((RealTimeContactAnalysisSegmentEvent)builder.build());
    }

    public static RealtimeContactAnalysisSegment fromAttachments(RealTimeContactAnalysisSegmentAttachments attachments) {
        return (RealtimeContactAnalysisSegment)RealtimeContactAnalysisSegment.builder().attachments(attachments).build();
    }

    public static RealtimeContactAnalysisSegment fromAttachments(Consumer<RealTimeContactAnalysisSegmentAttachments.Builder> attachments) {
        RealTimeContactAnalysisSegmentAttachments.Builder builder = RealTimeContactAnalysisSegmentAttachments.builder();
        attachments.accept(builder);
        return RealtimeContactAnalysisSegment.fromAttachments((RealTimeContactAnalysisSegmentAttachments)builder.build());
    }

    public static RealtimeContactAnalysisSegment fromPostContactSummary(RealTimeContactAnalysisSegmentPostContactSummary postContactSummary) {
        return (RealtimeContactAnalysisSegment)RealtimeContactAnalysisSegment.builder().postContactSummary(postContactSummary).build();
    }

    public static RealtimeContactAnalysisSegment fromPostContactSummary(Consumer<RealTimeContactAnalysisSegmentPostContactSummary.Builder> postContactSummary) {
        RealTimeContactAnalysisSegmentPostContactSummary.Builder builder = RealTimeContactAnalysisSegmentPostContactSummary.builder();
        postContactSummary.accept(builder);
        return RealtimeContactAnalysisSegment.fromPostContactSummary((RealTimeContactAnalysisSegmentPostContactSummary)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Transcript", TRANSCRIPT_FIELD);
        map.put("Categories", CATEGORIES_FIELD);
        map.put("Issues", ISSUES_FIELD);
        map.put("Event", EVENT_FIELD);
        map.put("Attachments", ATTACHMENTS_FIELD);
        map.put("PostContactSummary", POST_CONTACT_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RealtimeContactAnalysisSegment, T> g) {
        return obj -> g.apply((RealtimeContactAnalysisSegment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TRANSCRIPT,
        CATEGORIES,
        ISSUES,
        EVENT,
        ATTACHMENTS,
        POST_CONTACT_SUMMARY,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private RealTimeContactAnalysisSegmentTranscript transcript;
        private RealTimeContactAnalysisSegmentCategories categories;
        private RealTimeContactAnalysisSegmentIssues issues;
        private RealTimeContactAnalysisSegmentEvent event;
        private RealTimeContactAnalysisSegmentAttachments attachments;
        private RealTimeContactAnalysisSegmentPostContactSummary postContactSummary;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RealtimeContactAnalysisSegment model) {
            this.transcript(model.transcript);
            this.categories(model.categories);
            this.issues(model.issues);
            this.event(model.event);
            this.attachments(model.attachments);
            this.postContactSummary(model.postContactSummary);
        }

        public final RealTimeContactAnalysisSegmentTranscript.Builder getTranscript() {
            return this.transcript != null ? this.transcript.toBuilder() : null;
        }

        public final void setTranscript(RealTimeContactAnalysisSegmentTranscript.BuilderImpl transcript) {
            RealTimeContactAnalysisSegmentTranscript oldValue = this.transcript;
            this.transcript = transcript != null ? transcript.build() : null;
            this.handleUnionValueChange(Type.TRANSCRIPT, oldValue, this.transcript);
        }

        @Override
        public final Builder transcript(RealTimeContactAnalysisSegmentTranscript transcript) {
            RealTimeContactAnalysisSegmentTranscript oldValue = this.transcript;
            this.transcript = transcript;
            this.handleUnionValueChange(Type.TRANSCRIPT, oldValue, this.transcript);
            return this;
        }

        public final RealTimeContactAnalysisSegmentCategories.Builder getCategories() {
            return this.categories != null ? this.categories.toBuilder() : null;
        }

        public final void setCategories(RealTimeContactAnalysisSegmentCategories.BuilderImpl categories) {
            RealTimeContactAnalysisSegmentCategories oldValue = this.categories;
            this.categories = categories != null ? categories.build() : null;
            this.handleUnionValueChange(Type.CATEGORIES, oldValue, this.categories);
        }

        @Override
        public final Builder categories(RealTimeContactAnalysisSegmentCategories categories) {
            RealTimeContactAnalysisSegmentCategories oldValue = this.categories;
            this.categories = categories;
            this.handleUnionValueChange(Type.CATEGORIES, oldValue, this.categories);
            return this;
        }

        public final RealTimeContactAnalysisSegmentIssues.Builder getIssues() {
            return this.issues != null ? this.issues.toBuilder() : null;
        }

        public final void setIssues(RealTimeContactAnalysisSegmentIssues.BuilderImpl issues) {
            RealTimeContactAnalysisSegmentIssues oldValue = this.issues;
            this.issues = issues != null ? issues.build() : null;
            this.handleUnionValueChange(Type.ISSUES, oldValue, this.issues);
        }

        @Override
        public final Builder issues(RealTimeContactAnalysisSegmentIssues issues) {
            RealTimeContactAnalysisSegmentIssues oldValue = this.issues;
            this.issues = issues;
            this.handleUnionValueChange(Type.ISSUES, oldValue, this.issues);
            return this;
        }

        public final RealTimeContactAnalysisSegmentEvent.Builder getEvent() {
            return this.event != null ? this.event.toBuilder() : null;
        }

        public final void setEvent(RealTimeContactAnalysisSegmentEvent.BuilderImpl event) {
            RealTimeContactAnalysisSegmentEvent oldValue = this.event;
            this.event = event != null ? event.build() : null;
            this.handleUnionValueChange(Type.EVENT, oldValue, this.event);
        }

        @Override
        public final Builder event(RealTimeContactAnalysisSegmentEvent event) {
            RealTimeContactAnalysisSegmentEvent oldValue = this.event;
            this.event = event;
            this.handleUnionValueChange(Type.EVENT, oldValue, this.event);
            return this;
        }

        public final RealTimeContactAnalysisSegmentAttachments.Builder getAttachments() {
            return this.attachments != null ? this.attachments.toBuilder() : null;
        }

        public final void setAttachments(RealTimeContactAnalysisSegmentAttachments.BuilderImpl attachments) {
            RealTimeContactAnalysisSegmentAttachments oldValue = this.attachments;
            this.attachments = attachments != null ? attachments.build() : null;
            this.handleUnionValueChange(Type.ATTACHMENTS, oldValue, this.attachments);
        }

        @Override
        public final Builder attachments(RealTimeContactAnalysisSegmentAttachments attachments) {
            RealTimeContactAnalysisSegmentAttachments oldValue = this.attachments;
            this.attachments = attachments;
            this.handleUnionValueChange(Type.ATTACHMENTS, oldValue, this.attachments);
            return this;
        }

        public final RealTimeContactAnalysisSegmentPostContactSummary.Builder getPostContactSummary() {
            return this.postContactSummary != null ? this.postContactSummary.toBuilder() : null;
        }

        public final void setPostContactSummary(RealTimeContactAnalysisSegmentPostContactSummary.BuilderImpl postContactSummary) {
            RealTimeContactAnalysisSegmentPostContactSummary oldValue = this.postContactSummary;
            this.postContactSummary = postContactSummary != null ? postContactSummary.build() : null;
            this.handleUnionValueChange(Type.POST_CONTACT_SUMMARY, oldValue, this.postContactSummary);
        }

        @Override
        public final Builder postContactSummary(RealTimeContactAnalysisSegmentPostContactSummary postContactSummary) {
            RealTimeContactAnalysisSegmentPostContactSummary oldValue = this.postContactSummary;
            this.postContactSummary = postContactSummary;
            this.handleUnionValueChange(Type.POST_CONTACT_SUMMARY, oldValue, this.postContactSummary);
            return this;
        }

        public RealtimeContactAnalysisSegment build() {
            return new RealtimeContactAnalysisSegment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RealtimeContactAnalysisSegment> {
        public Builder transcript(RealTimeContactAnalysisSegmentTranscript var1);

        default public Builder transcript(Consumer<RealTimeContactAnalysisSegmentTranscript.Builder> transcript) {
            return this.transcript((RealTimeContactAnalysisSegmentTranscript)((RealTimeContactAnalysisSegmentTranscript.Builder)RealTimeContactAnalysisSegmentTranscript.builder().applyMutation(transcript)).build());
        }

        public Builder categories(RealTimeContactAnalysisSegmentCategories var1);

        default public Builder categories(Consumer<RealTimeContactAnalysisSegmentCategories.Builder> categories) {
            return this.categories((RealTimeContactAnalysisSegmentCategories)((RealTimeContactAnalysisSegmentCategories.Builder)RealTimeContactAnalysisSegmentCategories.builder().applyMutation(categories)).build());
        }

        public Builder issues(RealTimeContactAnalysisSegmentIssues var1);

        default public Builder issues(Consumer<RealTimeContactAnalysisSegmentIssues.Builder> issues) {
            return this.issues((RealTimeContactAnalysisSegmentIssues)((RealTimeContactAnalysisSegmentIssues.Builder)RealTimeContactAnalysisSegmentIssues.builder().applyMutation(issues)).build());
        }

        public Builder event(RealTimeContactAnalysisSegmentEvent var1);

        default public Builder event(Consumer<RealTimeContactAnalysisSegmentEvent.Builder> event) {
            return this.event((RealTimeContactAnalysisSegmentEvent)((RealTimeContactAnalysisSegmentEvent.Builder)RealTimeContactAnalysisSegmentEvent.builder().applyMutation(event)).build());
        }

        public Builder attachments(RealTimeContactAnalysisSegmentAttachments var1);

        default public Builder attachments(Consumer<RealTimeContactAnalysisSegmentAttachments.Builder> attachments) {
            return this.attachments((RealTimeContactAnalysisSegmentAttachments)((RealTimeContactAnalysisSegmentAttachments.Builder)RealTimeContactAnalysisSegmentAttachments.builder().applyMutation(attachments)).build());
        }

        public Builder postContactSummary(RealTimeContactAnalysisSegmentPostContactSummary var1);

        default public Builder postContactSummary(Consumer<RealTimeContactAnalysisSegmentPostContactSummary.Builder> postContactSummary) {
            return this.postContactSummary((RealTimeContactAnalysisSegmentPostContactSummary)((RealTimeContactAnalysisSegmentPostContactSummary.Builder)RealTimeContactAnalysisSegmentPostContactSummary.builder().applyMutation(postContactSummary)).build());
        }
    }
}

