/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.AgentStatus;
import software.amazon.awssdk.services.connect.model.SearchAgentStatusesRequest;
import software.amazon.awssdk.services.connect.model.SearchAgentStatusesResponse;

public class SearchAgentStatusesIterable
implements SdkIterable<SearchAgentStatusesResponse> {
    private final ConnectClient client;
    private final SearchAgentStatusesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchAgentStatusesIterable(ConnectClient client, SearchAgentStatusesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchAgentStatusesResponseFetcher();
    }

    public Iterator<SearchAgentStatusesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AgentStatus> agentStatuses() {
        Function<SearchAgentStatusesResponse, Iterator> getIterator = response -> {
            if (response != null && response.agentStatuses() != null) {
                return response.agentStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchAgentStatusesResponseFetcher
    implements SyncPageFetcher<SearchAgentStatusesResponse> {
        private SearchAgentStatusesResponseFetcher() {
        }

        public boolean hasNextPage(SearchAgentStatusesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchAgentStatusesResponse nextPage(SearchAgentStatusesResponse previousPage) {
            if (previousPage == null) {
                return SearchAgentStatusesIterable.this.client.searchAgentStatuses(SearchAgentStatusesIterable.this.firstRequest);
            }
            return SearchAgentStatusesIterable.this.client.searchAgentStatuses((SearchAgentStatusesRequest)((Object)SearchAgentStatusesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

