/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AgentAvailabilityTimer;
import software.amazon.awssdk.services.connect.model.AssociatedQueueIdListCopier;
import software.amazon.awssdk.services.connect.model.MediaConcurrenciesCopier;
import software.amazon.awssdk.services.connect.model.MediaConcurrency;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoutingProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoutingProfile> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(RoutingProfile.getter(RoutingProfile::instanceId)).setter(RoutingProfile.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RoutingProfile.getter(RoutingProfile::name)).setter(RoutingProfile.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ROUTING_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingProfileArn").getter(RoutingProfile.getter(RoutingProfile::routingProfileArn)).setter(RoutingProfile.setter(Builder::routingProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileArn").build()}).build();
    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingProfileId").getter(RoutingProfile.getter(RoutingProfile::routingProfileId)).setter(RoutingProfile.setter(Builder::routingProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RoutingProfile.getter(RoutingProfile::description)).setter(RoutingProfile.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<MediaConcurrency>> MEDIA_CONCURRENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaConcurrencies").getter(RoutingProfile.getter(RoutingProfile::mediaConcurrencies)).setter(RoutingProfile.setter(Builder::mediaConcurrencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaConcurrencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaConcurrency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_OUTBOUND_QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultOutboundQueueId").getter(RoutingProfile.getter(RoutingProfile::defaultOutboundQueueId)).setter(RoutingProfile.setter(Builder::defaultOutboundQueueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOutboundQueueId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(RoutingProfile.getter(RoutingProfile::tags)).setter(RoutingProfile.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> NUMBER_OF_ASSOCIATED_QUEUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfAssociatedQueues").getter(RoutingProfile.getter(RoutingProfile::numberOfAssociatedQueues)).setter(RoutingProfile.setter(Builder::numberOfAssociatedQueues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAssociatedQueues").build()}).build();
    private static final SdkField<Long> NUMBER_OF_ASSOCIATED_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfAssociatedUsers").getter(RoutingProfile.getter(RoutingProfile::numberOfAssociatedUsers)).setter(RoutingProfile.setter(Builder::numberOfAssociatedUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAssociatedUsers").build()}).build();
    private static final SdkField<String> AGENT_AVAILABILITY_TIMER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AgentAvailabilityTimer").getter(RoutingProfile.getter(RoutingProfile::agentAvailabilityTimerAsString)).setter(RoutingProfile.setter(Builder::agentAvailabilityTimer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentAvailabilityTimer").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(RoutingProfile.getter(RoutingProfile::lastModifiedTime)).setter(RoutingProfile.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedRegion").getter(RoutingProfile.getter(RoutingProfile::lastModifiedRegion)).setter(RoutingProfile.setter(Builder::lastModifiedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefault").getter(RoutingProfile.getter(RoutingProfile::isDefault)).setter(RoutingProfile.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_QUEUE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedQueueIds").getter(RoutingProfile.getter(RoutingProfile::associatedQueueIds)).setter(RoutingProfile.setter(Builder::associatedQueueIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedQueueIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NAME_FIELD, ROUTING_PROFILE_ARN_FIELD, ROUTING_PROFILE_ID_FIELD, DESCRIPTION_FIELD, MEDIA_CONCURRENCIES_FIELD, DEFAULT_OUTBOUND_QUEUE_ID_FIELD, TAGS_FIELD, NUMBER_OF_ASSOCIATED_QUEUES_FIELD, NUMBER_OF_ASSOCIATED_USERS_FIELD, AGENT_AVAILABILITY_TIMER_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD, IS_DEFAULT_FIELD, ASSOCIATED_QUEUE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RoutingProfile.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String name;
    private final String routingProfileArn;
    private final String routingProfileId;
    private final String description;
    private final List<MediaConcurrency> mediaConcurrencies;
    private final String defaultOutboundQueueId;
    private final Map<String, String> tags;
    private final Long numberOfAssociatedQueues;
    private final Long numberOfAssociatedUsers;
    private final String agentAvailabilityTimer;
    private final Instant lastModifiedTime;
    private final String lastModifiedRegion;
    private final Boolean isDefault;
    private final List<String> associatedQueueIds;

    private RoutingProfile(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.routingProfileArn = builder.routingProfileArn;
        this.routingProfileId = builder.routingProfileId;
        this.description = builder.description;
        this.mediaConcurrencies = builder.mediaConcurrencies;
        this.defaultOutboundQueueId = builder.defaultOutboundQueueId;
        this.tags = builder.tags;
        this.numberOfAssociatedQueues = builder.numberOfAssociatedQueues;
        this.numberOfAssociatedUsers = builder.numberOfAssociatedUsers;
        this.agentAvailabilityTimer = builder.agentAvailabilityTimer;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
        this.isDefault = builder.isDefault;
        this.associatedQueueIds = builder.associatedQueueIds;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String name() {
        return this.name;
    }

    public final String routingProfileArn() {
        return this.routingProfileArn;
    }

    public final String routingProfileId() {
        return this.routingProfileId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasMediaConcurrencies() {
        return this.mediaConcurrencies != null && !(this.mediaConcurrencies instanceof SdkAutoConstructList);
    }

    public final List<MediaConcurrency> mediaConcurrencies() {
        return this.mediaConcurrencies;
    }

    public final String defaultOutboundQueueId() {
        return this.defaultOutboundQueueId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Long numberOfAssociatedQueues() {
        return this.numberOfAssociatedQueues;
    }

    public final Long numberOfAssociatedUsers() {
        return this.numberOfAssociatedUsers;
    }

    public final AgentAvailabilityTimer agentAvailabilityTimer() {
        return AgentAvailabilityTimer.fromValue(this.agentAvailabilityTimer);
    }

    public final String agentAvailabilityTimerAsString() {
        return this.agentAvailabilityTimer;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public final boolean hasAssociatedQueueIds() {
        return this.associatedQueueIds != null && !(this.associatedQueueIds instanceof SdkAutoConstructList);
    }

    public final List<String> associatedQueueIds() {
        return this.associatedQueueIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaConcurrencies() ? this.mediaConcurrencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultOutboundQueueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAssociatedQueues());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAssociatedUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAvailabilityTimerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedQueueIds() ? this.associatedQueueIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingProfile)) {
            return false;
        }
        RoutingProfile other = (RoutingProfile)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.routingProfileArn(), other.routingProfileArn()) && Objects.equals(this.routingProfileId(), other.routingProfileId()) && Objects.equals(this.description(), other.description()) && this.hasMediaConcurrencies() == other.hasMediaConcurrencies() && Objects.equals(this.mediaConcurrencies(), other.mediaConcurrencies()) && Objects.equals(this.defaultOutboundQueueId(), other.defaultOutboundQueueId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.numberOfAssociatedQueues(), other.numberOfAssociatedQueues()) && Objects.equals(this.numberOfAssociatedUsers(), other.numberOfAssociatedUsers()) && Objects.equals(this.agentAvailabilityTimerAsString(), other.agentAvailabilityTimerAsString()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedRegion(), other.lastModifiedRegion()) && Objects.equals(this.isDefault(), other.isDefault()) && this.hasAssociatedQueueIds() == other.hasAssociatedQueueIds() && Objects.equals(this.associatedQueueIds(), other.associatedQueueIds());
    }

    public final String toString() {
        return ToString.builder((String)"RoutingProfile").add("InstanceId", (Object)this.instanceId()).add("Name", (Object)this.name()).add("RoutingProfileArn", (Object)this.routingProfileArn()).add("RoutingProfileId", (Object)this.routingProfileId()).add("Description", (Object)this.description()).add("MediaConcurrencies", this.hasMediaConcurrencies() ? this.mediaConcurrencies() : null).add("DefaultOutboundQueueId", (Object)this.defaultOutboundQueueId()).add("Tags", this.hasTags() ? this.tags() : null).add("NumberOfAssociatedQueues", (Object)this.numberOfAssociatedQueues()).add("NumberOfAssociatedUsers", (Object)this.numberOfAssociatedUsers()).add("AgentAvailabilityTimer", (Object)this.agentAvailabilityTimerAsString()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedRegion", (Object)this.lastModifiedRegion()).add("IsDefault", (Object)this.isDefault()).add("AssociatedQueueIds", this.hasAssociatedQueueIds() ? this.associatedQueueIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RoutingProfileArn": {
                return Optional.ofNullable(clazz.cast(this.routingProfileArn()));
            }
            case "RoutingProfileId": {
                return Optional.ofNullable(clazz.cast(this.routingProfileId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "MediaConcurrencies": {
                return Optional.ofNullable(clazz.cast(this.mediaConcurrencies()));
            }
            case "DefaultOutboundQueueId": {
                return Optional.ofNullable(clazz.cast(this.defaultOutboundQueueId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "NumberOfAssociatedQueues": {
                return Optional.ofNullable(clazz.cast(this.numberOfAssociatedQueues()));
            }
            case "NumberOfAssociatedUsers": {
                return Optional.ofNullable(clazz.cast(this.numberOfAssociatedUsers()));
            }
            case "AgentAvailabilityTimer": {
                return Optional.ofNullable(clazz.cast(this.agentAvailabilityTimerAsString()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedRegion()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
            case "AssociatedQueueIds": {
                return Optional.ofNullable(clazz.cast(this.associatedQueueIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RoutingProfileArn", ROUTING_PROFILE_ARN_FIELD);
        map.put("RoutingProfileId", ROUTING_PROFILE_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("MediaConcurrencies", MEDIA_CONCURRENCIES_FIELD);
        map.put("DefaultOutboundQueueId", DEFAULT_OUTBOUND_QUEUE_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("NumberOfAssociatedQueues", NUMBER_OF_ASSOCIATED_QUEUES_FIELD);
        map.put("NumberOfAssociatedUsers", NUMBER_OF_ASSOCIATED_USERS_FIELD);
        map.put("AgentAvailabilityTimer", AGENT_AVAILABILITY_TIMER_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        map.put("IsDefault", IS_DEFAULT_FIELD);
        map.put("AssociatedQueueIds", ASSOCIATED_QUEUE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutingProfile, T> g) {
        return obj -> g.apply((RoutingProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String name;
        private String routingProfileArn;
        private String routingProfileId;
        private String description;
        private List<MediaConcurrency> mediaConcurrencies = DefaultSdkAutoConstructList.getInstance();
        private String defaultOutboundQueueId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Long numberOfAssociatedQueues;
        private Long numberOfAssociatedUsers;
        private String agentAvailabilityTimer;
        private Instant lastModifiedTime;
        private String lastModifiedRegion;
        private Boolean isDefault;
        private List<String> associatedQueueIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingProfile model) {
            this.instanceId(model.instanceId);
            this.name(model.name);
            this.routingProfileArn(model.routingProfileArn);
            this.routingProfileId(model.routingProfileId);
            this.description(model.description);
            this.mediaConcurrencies(model.mediaConcurrencies);
            this.defaultOutboundQueueId(model.defaultOutboundQueueId);
            this.tags(model.tags);
            this.numberOfAssociatedQueues(model.numberOfAssociatedQueues);
            this.numberOfAssociatedUsers(model.numberOfAssociatedUsers);
            this.agentAvailabilityTimer(model.agentAvailabilityTimer);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedRegion(model.lastModifiedRegion);
            this.isDefault(model.isDefault);
            this.associatedQueueIds(model.associatedQueueIds);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoutingProfileArn() {
            return this.routingProfileArn;
        }

        public final void setRoutingProfileArn(String routingProfileArn) {
            this.routingProfileArn = routingProfileArn;
        }

        @Override
        public final Builder routingProfileArn(String routingProfileArn) {
            this.routingProfileArn = routingProfileArn;
            return this;
        }

        public final String getRoutingProfileId() {
            return this.routingProfileId;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<MediaConcurrency.Builder> getMediaConcurrencies() {
            List<MediaConcurrency.Builder> result = MediaConcurrenciesCopier.copyToBuilder(this.mediaConcurrencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaConcurrencies(Collection<MediaConcurrency.BuilderImpl> mediaConcurrencies) {
            this.mediaConcurrencies = MediaConcurrenciesCopier.copyFromBuilder(mediaConcurrencies);
        }

        @Override
        public final Builder mediaConcurrencies(Collection<MediaConcurrency> mediaConcurrencies) {
            this.mediaConcurrencies = MediaConcurrenciesCopier.copy(mediaConcurrencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConcurrencies(MediaConcurrency ... mediaConcurrencies) {
            this.mediaConcurrencies(Arrays.asList(mediaConcurrencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConcurrencies(Consumer<MediaConcurrency.Builder> ... mediaConcurrencies) {
            this.mediaConcurrencies(Stream.of(mediaConcurrencies).map(c -> (MediaConcurrency)((MediaConcurrency.Builder)MediaConcurrency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultOutboundQueueId() {
            return this.defaultOutboundQueueId;
        }

        public final void setDefaultOutboundQueueId(String defaultOutboundQueueId) {
            this.defaultOutboundQueueId = defaultOutboundQueueId;
        }

        @Override
        public final Builder defaultOutboundQueueId(String defaultOutboundQueueId) {
            this.defaultOutboundQueueId = defaultOutboundQueueId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Long getNumberOfAssociatedQueues() {
            return this.numberOfAssociatedQueues;
        }

        public final void setNumberOfAssociatedQueues(Long numberOfAssociatedQueues) {
            this.numberOfAssociatedQueues = numberOfAssociatedQueues;
        }

        @Override
        public final Builder numberOfAssociatedQueues(Long numberOfAssociatedQueues) {
            this.numberOfAssociatedQueues = numberOfAssociatedQueues;
            return this;
        }

        public final Long getNumberOfAssociatedUsers() {
            return this.numberOfAssociatedUsers;
        }

        public final void setNumberOfAssociatedUsers(Long numberOfAssociatedUsers) {
            this.numberOfAssociatedUsers = numberOfAssociatedUsers;
        }

        @Override
        public final Builder numberOfAssociatedUsers(Long numberOfAssociatedUsers) {
            this.numberOfAssociatedUsers = numberOfAssociatedUsers;
            return this;
        }

        public final String getAgentAvailabilityTimer() {
            return this.agentAvailabilityTimer;
        }

        public final void setAgentAvailabilityTimer(String agentAvailabilityTimer) {
            this.agentAvailabilityTimer = agentAvailabilityTimer;
        }

        @Override
        public final Builder agentAvailabilityTimer(String agentAvailabilityTimer) {
            this.agentAvailabilityTimer = agentAvailabilityTimer;
            return this;
        }

        @Override
        public final Builder agentAvailabilityTimer(AgentAvailabilityTimer agentAvailabilityTimer) {
            this.agentAvailabilityTimer(agentAvailabilityTimer == null ? null : agentAvailabilityTimer.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return this.lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final Collection<String> getAssociatedQueueIds() {
            if (this.associatedQueueIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedQueueIds;
        }

        public final void setAssociatedQueueIds(Collection<String> associatedQueueIds) {
            this.associatedQueueIds = AssociatedQueueIdListCopier.copy(associatedQueueIds);
        }

        @Override
        public final Builder associatedQueueIds(Collection<String> associatedQueueIds) {
            this.associatedQueueIds = AssociatedQueueIdListCopier.copy(associatedQueueIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedQueueIds(String ... associatedQueueIds) {
            this.associatedQueueIds(Arrays.asList(associatedQueueIds));
            return this;
        }

        public RoutingProfile build() {
            return new RoutingProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoutingProfile> {
        public Builder instanceId(String var1);

        public Builder name(String var1);

        public Builder routingProfileArn(String var1);

        public Builder routingProfileId(String var1);

        public Builder description(String var1);

        public Builder mediaConcurrencies(Collection<MediaConcurrency> var1);

        public Builder mediaConcurrencies(MediaConcurrency ... var1);

        public Builder mediaConcurrencies(Consumer<MediaConcurrency.Builder> ... var1);

        public Builder defaultOutboundQueueId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder numberOfAssociatedQueues(Long var1);

        public Builder numberOfAssociatedUsers(Long var1);

        public Builder agentAvailabilityTimer(String var1);

        public Builder agentAvailabilityTimer(AgentAvailabilityTimer var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedRegion(String var1);

        public Builder isDefault(Boolean var1);

        public Builder associatedQueueIds(Collection<String> var1);

        public Builder associatedQueueIds(String ... var1);
    }
}

