/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListContactReferencesRequest;
import software.amazon.awssdk.services.connect.model.ListContactReferencesResponse;
import software.amazon.awssdk.services.connect.model.ReferenceSummary;

public class ListContactReferencesIterable
implements SdkIterable<ListContactReferencesResponse> {
    private final ConnectClient client;
    private final ListContactReferencesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContactReferencesIterable(ConnectClient client, ListContactReferencesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListContactReferencesResponseFetcher();
    }

    public Iterator<ListContactReferencesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReferenceSummary> referenceSummaryList() {
        Function<ListContactReferencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.referenceSummaryList() != null) {
                return response.referenceSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContactReferencesResponseFetcher
    implements SyncPageFetcher<ListContactReferencesResponse> {
        private ListContactReferencesResponseFetcher() {
        }

        public boolean hasNextPage(ListContactReferencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContactReferencesResponse nextPage(ListContactReferencesResponse previousPage) {
            if (previousPage == null) {
                return ListContactReferencesIterable.this.client.listContactReferences(ListContactReferencesIterable.this.firstRequest);
            }
            return ListContactReferencesIterable.this.client.listContactReferences((ListContactReferencesRequest)((Object)ListContactReferencesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

