/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThresholdV2
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThresholdV2> {
    private static final SdkField<String> COMPARISON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comparison").getter(ThresholdV2.getter(ThresholdV2::comparison)).setter(ThresholdV2.setter(Builder::comparison)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comparison").build()}).build();
    private static final SdkField<Double> THRESHOLD_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ThresholdValue").getter(ThresholdV2.getter(ThresholdV2::thresholdValue)).setter(ThresholdV2.setter(Builder::thresholdValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARISON_FIELD, THRESHOLD_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ThresholdV2.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String comparison;
    private final Double thresholdValue;

    private ThresholdV2(BuilderImpl builder) {
        this.comparison = builder.comparison;
        this.thresholdValue = builder.thresholdValue;
    }

    public final String comparison() {
        return this.comparison;
    }

    public final Double thresholdValue() {
        return this.thresholdValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comparison());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThresholdV2)) {
            return false;
        }
        ThresholdV2 other = (ThresholdV2)obj;
        return Objects.equals(this.comparison(), other.comparison()) && Objects.equals(this.thresholdValue(), other.thresholdValue());
    }

    public final String toString() {
        return ToString.builder((String)"ThresholdV2").add("Comparison", (Object)this.comparison()).add("ThresholdValue", (Object)this.thresholdValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Comparison": {
                return Optional.ofNullable(clazz.cast(this.comparison()));
            }
            case "ThresholdValue": {
                return Optional.ofNullable(clazz.cast(this.thresholdValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Comparison", COMPARISON_FIELD);
        map.put("ThresholdValue", THRESHOLD_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThresholdV2, T> g) {
        return obj -> g.apply((ThresholdV2)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comparison;
        private Double thresholdValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ThresholdV2 model) {
            this.comparison(model.comparison);
            this.thresholdValue(model.thresholdValue);
        }

        public final String getComparison() {
            return this.comparison;
        }

        public final void setComparison(String comparison) {
            this.comparison = comparison;
        }

        @Override
        public final Builder comparison(String comparison) {
            this.comparison = comparison;
            return this;
        }

        public final Double getThresholdValue() {
            return this.thresholdValue;
        }

        public final void setThresholdValue(Double thresholdValue) {
            this.thresholdValue = thresholdValue;
        }

        @Override
        public final Builder thresholdValue(Double thresholdValue) {
            this.thresholdValue = thresholdValue;
            return this;
        }

        public ThresholdV2 build() {
            return new ThresholdV2(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThresholdV2> {
        public Builder comparison(String var1);

        public Builder thresholdValue(Double var1);
    }
}

