/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.EvaluationSummary;
import software.amazon.awssdk.services.connect.model.EvaluationSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContactEvaluationsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListContactEvaluationsResponse> {
    private static final SdkField<List<EvaluationSummary>> EVALUATION_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EvaluationSummaryList").getter(ListContactEvaluationsResponse.getter(ListContactEvaluationsResponse::evaluationSummaryList)).setter(ListContactEvaluationsResponse.setter(Builder::evaluationSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListContactEvaluationsResponse.getter(ListContactEvaluationsResponse::nextToken)).setter(ListContactEvaluationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListContactEvaluationsResponse.memberNameToFieldInitializer();
    private final List<EvaluationSummary> evaluationSummaryList;
    private final String nextToken;

    private ListContactEvaluationsResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationSummaryList = builder.evaluationSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEvaluationSummaryList() {
        return this.evaluationSummaryList != null && !(this.evaluationSummaryList instanceof SdkAutoConstructList);
    }

    public final List<EvaluationSummary> evaluationSummaryList() {
        return this.evaluationSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluationSummaryList() ? this.evaluationSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactEvaluationsResponse)) {
            return false;
        }
        ListContactEvaluationsResponse other = (ListContactEvaluationsResponse)((Object)obj);
        return this.hasEvaluationSummaryList() == other.hasEvaluationSummaryList() && Objects.equals(this.evaluationSummaryList(), other.evaluationSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListContactEvaluationsResponse").add("EvaluationSummaryList", this.hasEvaluationSummaryList() ? this.evaluationSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationSummaryList": {
                return Optional.ofNullable(clazz.cast(this.evaluationSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EvaluationSummaryList", EVALUATION_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListContactEvaluationsResponse, T> g) {
        return obj -> g.apply((ListContactEvaluationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<EvaluationSummary> evaluationSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactEvaluationsResponse model) {
            super(model);
            this.evaluationSummaryList(model.evaluationSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<EvaluationSummary.Builder> getEvaluationSummaryList() {
            List<EvaluationSummary.Builder> result = EvaluationSummaryListCopier.copyToBuilder(this.evaluationSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluationSummaryList(Collection<EvaluationSummary.BuilderImpl> evaluationSummaryList) {
            this.evaluationSummaryList = EvaluationSummaryListCopier.copyFromBuilder(evaluationSummaryList);
        }

        @Override
        public final Builder evaluationSummaryList(Collection<EvaluationSummary> evaluationSummaryList) {
            this.evaluationSummaryList = EvaluationSummaryListCopier.copy(evaluationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationSummaryList(EvaluationSummary ... evaluationSummaryList) {
            this.evaluationSummaryList(Arrays.asList(evaluationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationSummaryList(Consumer<EvaluationSummary.Builder> ... evaluationSummaryList) {
            this.evaluationSummaryList(Stream.of(evaluationSummaryList).map(c -> (EvaluationSummary)((EvaluationSummary.Builder)EvaluationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListContactEvaluationsResponse build() {
            return new ListContactEvaluationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContactEvaluationsResponse> {
        public Builder evaluationSummaryList(Collection<EvaluationSummary> var1);

        public Builder evaluationSummaryList(EvaluationSummary ... var1);

        public Builder evaluationSummaryList(Consumer<EvaluationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

