/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.HoursOfOperationOverride;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationOverridesRequest;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationOverridesResponse;

public class ListHoursOfOperationOverridesPublisher
implements SdkPublisher<ListHoursOfOperationOverridesResponse> {
    private final ConnectAsyncClient client;
    private final ListHoursOfOperationOverridesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListHoursOfOperationOverridesPublisher(ConnectAsyncClient client, ListHoursOfOperationOverridesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListHoursOfOperationOverridesPublisher(ConnectAsyncClient client, ListHoursOfOperationOverridesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListHoursOfOperationOverridesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListHoursOfOperationOverridesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HoursOfOperationOverride> hoursOfOperationOverrideList() {
        Function<ListHoursOfOperationOverridesResponse, Iterator> getIterator = response -> {
            if (response != null && response.hoursOfOperationOverrideList() != null) {
                return response.hoursOfOperationOverrideList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListHoursOfOperationOverridesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListHoursOfOperationOverridesResponseFetcher
    implements AsyncPageFetcher<ListHoursOfOperationOverridesResponse> {
        private ListHoursOfOperationOverridesResponseFetcher() {
        }

        public boolean hasNextPage(ListHoursOfOperationOverridesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListHoursOfOperationOverridesResponse> nextPage(ListHoursOfOperationOverridesResponse previousPage) {
            if (previousPage == null) {
                return ListHoursOfOperationOverridesPublisher.this.client.listHoursOfOperationOverrides(ListHoursOfOperationOverridesPublisher.this.firstRequest);
            }
            return ListHoursOfOperationOverridesPublisher.this.client.listHoursOfOperationOverrides((ListHoursOfOperationOverridesRequest)((Object)ListHoursOfOperationOverridesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

