/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateContactFlowVersionRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, CreateContactFlowVersionRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CreateContactFlowVersionRequest.getter(CreateContactFlowVersionRequest::instanceId)).setter(CreateContactFlowVersionRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateContactFlowVersionRequest.getter(CreateContactFlowVersionRequest::description)).setter(CreateContactFlowVersionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactFlowId").getter(CreateContactFlowVersionRequest.getter(CreateContactFlowVersionRequest::contactFlowId)).setter(CreateContactFlowVersionRequest.setter(Builder::contactFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactFlowId").build()}).build();
    private static final SdkField<String> FLOW_CONTENT_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowContentSha256").getter(CreateContactFlowVersionRequest.getter(CreateContactFlowVersionRequest::flowContentSha256)).setter(CreateContactFlowVersionRequest.setter(Builder::flowContentSha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowContentSha256").build()}).build();
    private static final SdkField<Long> CONTACT_FLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ContactFlowVersion").getter(CreateContactFlowVersionRequest.getter(CreateContactFlowVersionRequest::contactFlowVersion)).setter(CreateContactFlowVersionRequest.setter(Builder::contactFlowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowVersion").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(CreateContactFlowVersionRequest.getter(CreateContactFlowVersionRequest::lastModifiedTime)).setter(CreateContactFlowVersionRequest.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedRegion").getter(CreateContactFlowVersionRequest.getter(CreateContactFlowVersionRequest::lastModifiedRegion)).setter(CreateContactFlowVersionRequest.setter(Builder::lastModifiedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, DESCRIPTION_FIELD, CONTACT_FLOW_ID_FIELD, FLOW_CONTENT_SHA256_FIELD, CONTACT_FLOW_VERSION_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateContactFlowVersionRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String description;
    private final String contactFlowId;
    private final String flowContentSha256;
    private final Long contactFlowVersion;
    private final Instant lastModifiedTime;
    private final String lastModifiedRegion;

    private CreateContactFlowVersionRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.description = builder.description;
        this.contactFlowId = builder.contactFlowId;
        this.flowContentSha256 = builder.flowContentSha256;
        this.contactFlowVersion = builder.contactFlowVersion;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String description() {
        return this.description;
    }

    public final String contactFlowId() {
        return this.contactFlowId;
    }

    public final String flowContentSha256() {
        return this.flowContentSha256;
    }

    public final Long contactFlowVersion() {
        return this.contactFlowVersion;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowContentSha256());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactFlowVersionRequest)) {
            return false;
        }
        CreateContactFlowVersionRequest other = (CreateContactFlowVersionRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.contactFlowId(), other.contactFlowId()) && Objects.equals(this.flowContentSha256(), other.flowContentSha256()) && Objects.equals(this.contactFlowVersion(), other.contactFlowVersion()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedRegion(), other.lastModifiedRegion());
    }

    public final String toString() {
        return ToString.builder((String)"CreateContactFlowVersionRequest").add("InstanceId", (Object)this.instanceId()).add("Description", (Object)this.description()).add("ContactFlowId", (Object)this.contactFlowId()).add("FlowContentSha256", (Object)this.flowContentSha256()).add("ContactFlowVersion", (Object)this.contactFlowVersion()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedRegion", (Object)this.lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ContactFlowId": {
                return Optional.ofNullable(clazz.cast(this.contactFlowId()));
            }
            case "FlowContentSha256": {
                return Optional.ofNullable(clazz.cast(this.flowContentSha256()));
            }
            case "ContactFlowVersion": {
                return Optional.ofNullable(clazz.cast(this.contactFlowVersion()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ContactFlowId", CONTACT_FLOW_ID_FIELD);
        map.put("FlowContentSha256", FLOW_CONTENT_SHA256_FIELD);
        map.put("ContactFlowVersion", CONTACT_FLOW_VERSION_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateContactFlowVersionRequest, T> g) {
        return obj -> g.apply((CreateContactFlowVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String description;
        private String contactFlowId;
        private String flowContentSha256;
        private Long contactFlowVersion;
        private Instant lastModifiedTime;
        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactFlowVersionRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.description(model.description);
            this.contactFlowId(model.contactFlowId);
            this.flowContentSha256(model.flowContentSha256);
            this.contactFlowVersion(model.contactFlowVersion);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getContactFlowId() {
            return this.contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final String getFlowContentSha256() {
            return this.flowContentSha256;
        }

        public final void setFlowContentSha256(String flowContentSha256) {
            this.flowContentSha256 = flowContentSha256;
        }

        @Override
        public final Builder flowContentSha256(String flowContentSha256) {
            this.flowContentSha256 = flowContentSha256;
            return this;
        }

        public final Long getContactFlowVersion() {
            return this.contactFlowVersion;
        }

        public final void setContactFlowVersion(Long contactFlowVersion) {
            this.contactFlowVersion = contactFlowVersion;
        }

        @Override
        public final Builder contactFlowVersion(Long contactFlowVersion) {
            this.contactFlowVersion = contactFlowVersion;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return this.lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContactFlowVersionRequest build() {
            return new CreateContactFlowVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateContactFlowVersionRequest> {
        public Builder instanceId(String var1);

        public Builder description(String var1);

        public Builder contactFlowId(String var1);

        public Builder flowContentSha256(String var1);

        public Builder contactFlowVersion(Long var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedRegion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

