/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.OverrideDays;
import software.amazon.awssdk.services.connect.model.OverrideTimeSlice;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HoursOfOperationOverrideConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HoursOfOperationOverrideConfig> {
    private static final SdkField<String> DAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Day").getter(HoursOfOperationOverrideConfig.getter(HoursOfOperationOverrideConfig::dayAsString)).setter(HoursOfOperationOverrideConfig.setter(Builder::day)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Day").build()}).build();
    private static final SdkField<OverrideTimeSlice> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StartTime").getter(HoursOfOperationOverrideConfig.getter(HoursOfOperationOverrideConfig::startTime)).setter(HoursOfOperationOverrideConfig.setter(Builder::startTime)).constructor(OverrideTimeSlice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<OverrideTimeSlice> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndTime").getter(HoursOfOperationOverrideConfig.getter(HoursOfOperationOverrideConfig::endTime)).setter(HoursOfOperationOverrideConfig.setter(Builder::endTime)).constructor(OverrideTimeSlice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAY_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HoursOfOperationOverrideConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String day;
    private final OverrideTimeSlice startTime;
    private final OverrideTimeSlice endTime;

    private HoursOfOperationOverrideConfig(BuilderImpl builder) {
        this.day = builder.day;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final OverrideDays day() {
        return OverrideDays.fromValue(this.day);
    }

    public final String dayAsString() {
        return this.day;
    }

    public final OverrideTimeSlice startTime() {
        return this.startTime;
    }

    public final OverrideTimeSlice endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HoursOfOperationOverrideConfig)) {
            return false;
        }
        HoursOfOperationOverrideConfig other = (HoursOfOperationOverrideConfig)obj;
        return Objects.equals(this.dayAsString(), other.dayAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"HoursOfOperationOverrideConfig").add("Day", (Object)this.dayAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Day": {
                return Optional.ofNullable(clazz.cast(this.dayAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Day", DAY_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HoursOfOperationOverrideConfig, T> g) {
        return obj -> g.apply((HoursOfOperationOverrideConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String day;
        private OverrideTimeSlice startTime;
        private OverrideTimeSlice endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(HoursOfOperationOverrideConfig model) {
            this.day(model.day);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getDay() {
            return this.day;
        }

        public final void setDay(String day) {
            this.day = day;
        }

        @Override
        public final Builder day(String day) {
            this.day = day;
            return this;
        }

        @Override
        public final Builder day(OverrideDays day) {
            this.day(day == null ? null : day.toString());
            return this;
        }

        public final OverrideTimeSlice.Builder getStartTime() {
            return this.startTime != null ? this.startTime.toBuilder() : null;
        }

        public final void setStartTime(OverrideTimeSlice.BuilderImpl startTime) {
            this.startTime = startTime != null ? startTime.build() : null;
        }

        @Override
        public final Builder startTime(OverrideTimeSlice startTime) {
            this.startTime = startTime;
            return this;
        }

        public final OverrideTimeSlice.Builder getEndTime() {
            return this.endTime != null ? this.endTime.toBuilder() : null;
        }

        public final void setEndTime(OverrideTimeSlice.BuilderImpl endTime) {
            this.endTime = endTime != null ? endTime.build() : null;
        }

        @Override
        public final Builder endTime(OverrideTimeSlice endTime) {
            this.endTime = endTime;
            return this;
        }

        public HoursOfOperationOverrideConfig build() {
            return new HoursOfOperationOverrideConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HoursOfOperationOverrideConfig> {
        public Builder day(String var1);

        public Builder day(OverrideDays var1);

        public Builder startTime(OverrideTimeSlice var1);

        default public Builder startTime(Consumer<OverrideTimeSlice.Builder> startTime) {
            return this.startTime((OverrideTimeSlice)((OverrideTimeSlice.Builder)OverrideTimeSlice.builder().applyMutation(startTime)).build());
        }

        public Builder endTime(OverrideTimeSlice var1);

        default public Builder endTime(Consumer<OverrideTimeSlice.Builder> endTime) {
            return this.endTime((OverrideTimeSlice)((OverrideTimeSlice.Builder)OverrideTimeSlice.builder().applyMutation(endTime)).build());
        }
    }
}

