/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.EmailHeaderType;
import software.amazon.awssdk.services.connect.model.EmailHeadersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InboundRawMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InboundRawMessage> {
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subject").getter(InboundRawMessage.getter(InboundRawMessage::subject)).setter(InboundRawMessage.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(InboundRawMessage.getter(InboundRawMessage::body)).setter(InboundRawMessage.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(InboundRawMessage.getter(InboundRawMessage::contentType)).setter(InboundRawMessage.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final SdkField<Map<String, String>> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Headers").getter(InboundRawMessage.getter(InboundRawMessage::headersAsStrings)).setter(InboundRawMessage.setter(Builder::headersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD, BODY_FIELD, CONTENT_TYPE_FIELD, HEADERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InboundRawMessage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String subject;
    private final String body;
    private final String contentType;
    private final Map<String, String> headers;

    private InboundRawMessage(BuilderImpl builder) {
        this.subject = builder.subject;
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.headers = builder.headers;
    }

    public final String subject() {
        return this.subject;
    }

    public final String body() {
        return this.body;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final Map<EmailHeaderType, String> headers() {
        return EmailHeadersCopier.copyStringToEnum(this.headers);
    }

    public final boolean hasHeaders() {
        return this.headers != null && !(this.headers instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> headersAsStrings() {
        return this.headers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaders() ? this.headersAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InboundRawMessage)) {
            return false;
        }
        InboundRawMessage other = (InboundRawMessage)obj;
        return Objects.equals(this.subject(), other.subject()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.contentType(), other.contentType()) && this.hasHeaders() == other.hasHeaders() && Objects.equals(this.headersAsStrings(), other.headersAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"InboundRawMessage").add("Subject", (Object)(this.subject() == null ? null : "*** Sensitive Data Redacted ***")).add("Body", (Object)(this.body() == null ? null : "*** Sensitive Data Redacted ***")).add("ContentType", (Object)this.contentType()).add("Headers", this.hasHeaders() ? this.headersAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "Headers": {
                return Optional.ofNullable(clazz.cast(this.headersAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Subject", SUBJECT_FIELD);
        map.put("Body", BODY_FIELD);
        map.put("ContentType", CONTENT_TYPE_FIELD);
        map.put("Headers", HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InboundRawMessage, T> g) {
        return obj -> g.apply((InboundRawMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subject;
        private String body;
        private String contentType;
        private Map<String, String> headers = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InboundRawMessage model) {
            this.subject(model.subject);
            this.body(model.body);
            this.contentType(model.contentType);
            this.headersWithStrings(model.headers);
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final Map<String, String> getHeaders() {
            if (this.headers instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.headers;
        }

        public final void setHeaders(Map<String, String> headers) {
            this.headers = EmailHeadersCopier.copy(headers);
        }

        @Override
        public final Builder headersWithStrings(Map<String, String> headers) {
            this.headers = EmailHeadersCopier.copy(headers);
            return this;
        }

        @Override
        public final Builder headers(Map<EmailHeaderType, String> headers) {
            this.headers = EmailHeadersCopier.copyEnumToString(headers);
            return this;
        }

        public InboundRawMessage build() {
            return new InboundRawMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InboundRawMessage> {
        public Builder subject(String var1);

        public Builder body(String var1);

        public Builder contentType(String var1);

        public Builder headersWithStrings(Map<String, String> var1);

        public Builder headers(Map<EmailHeaderType, String> var1);
    }
}

