/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListViewVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListViewVersionsResponse;
import software.amazon.awssdk.services.connect.model.ViewVersionSummary;

public class ListViewVersionsIterable
implements SdkIterable<ListViewVersionsResponse> {
    private final ConnectClient client;
    private final ListViewVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListViewVersionsIterable(ConnectClient client, ListViewVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListViewVersionsResponseFetcher();
    }

    public Iterator<ListViewVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ViewVersionSummary> viewVersionSummaryList() {
        Function<ListViewVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.viewVersionSummaryList() != null) {
                return response.viewVersionSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListViewVersionsResponseFetcher
    implements SyncPageFetcher<ListViewVersionsResponse> {
        private ListViewVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListViewVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListViewVersionsResponse nextPage(ListViewVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListViewVersionsIterable.this.client.listViewVersions(ListViewVersionsIterable.this.firstRequest);
            }
            return ListViewVersionsIterable.this.client.listViewVersions((ListViewVersionsRequest)((Object)ListViewVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

