/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.SearchContactsMatchType;
import software.amazon.awssdk.services.connect.model.SearchableContactAttributesCriteria;
import software.amazon.awssdk.services.connect.model.SearchableContactAttributesCriteriaListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchableContactAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchableContactAttributes> {
    private static final SdkField<List<SearchableContactAttributesCriteria>> CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Criteria").getter(SearchableContactAttributes.getter(SearchableContactAttributes::criteria)).setter(SearchableContactAttributes.setter(Builder::criteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criteria").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchableContactAttributesCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MATCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatchType").getter(SearchableContactAttributes.getter(SearchableContactAttributes::matchTypeAsString)).setter(SearchableContactAttributes.setter(Builder::matchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRITERIA_FIELD, MATCH_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchableContactAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<SearchableContactAttributesCriteria> criteria;
    private final String matchType;

    private SearchableContactAttributes(BuilderImpl builder) {
        this.criteria = builder.criteria;
        this.matchType = builder.matchType;
    }

    public final boolean hasCriteria() {
        return this.criteria != null && !(this.criteria instanceof SdkAutoConstructList);
    }

    public final List<SearchableContactAttributesCriteria> criteria() {
        return this.criteria;
    }

    public final SearchContactsMatchType matchType() {
        return SearchContactsMatchType.fromValue(this.matchType);
    }

    public final String matchTypeAsString() {
        return this.matchType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCriteria() ? this.criteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.matchTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchableContactAttributes)) {
            return false;
        }
        SearchableContactAttributes other = (SearchableContactAttributes)obj;
        return this.hasCriteria() == other.hasCriteria() && Objects.equals(this.criteria(), other.criteria()) && Objects.equals(this.matchTypeAsString(), other.matchTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SearchableContactAttributes").add("Criteria", this.hasCriteria() ? this.criteria() : null).add("MatchType", (Object)this.matchTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Criteria": {
                return Optional.ofNullable(clazz.cast(this.criteria()));
            }
            case "MatchType": {
                return Optional.ofNullable(clazz.cast(this.matchTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Criteria", CRITERIA_FIELD);
        map.put("MatchType", MATCH_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchableContactAttributes, T> g) {
        return obj -> g.apply((SearchableContactAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SearchableContactAttributesCriteria> criteria = DefaultSdkAutoConstructList.getInstance();
        private String matchType;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchableContactAttributes model) {
            this.criteria(model.criteria);
            this.matchType(model.matchType);
        }

        public final List<SearchableContactAttributesCriteria.Builder> getCriteria() {
            List<SearchableContactAttributesCriteria.Builder> result = SearchableContactAttributesCriteriaListCopier.copyToBuilder(this.criteria);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCriteria(Collection<SearchableContactAttributesCriteria.BuilderImpl> criteria) {
            this.criteria = SearchableContactAttributesCriteriaListCopier.copyFromBuilder(criteria);
        }

        @Override
        public final Builder criteria(Collection<SearchableContactAttributesCriteria> criteria) {
            this.criteria = SearchableContactAttributesCriteriaListCopier.copy(criteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder criteria(SearchableContactAttributesCriteria ... criteria) {
            this.criteria(Arrays.asList(criteria));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder criteria(Consumer<SearchableContactAttributesCriteria.Builder> ... criteria) {
            this.criteria(Stream.of(criteria).map(c -> (SearchableContactAttributesCriteria)((SearchableContactAttributesCriteria.Builder)SearchableContactAttributesCriteria.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMatchType() {
            return this.matchType;
        }

        public final void setMatchType(String matchType) {
            this.matchType = matchType;
        }

        @Override
        public final Builder matchType(String matchType) {
            this.matchType = matchType;
            return this;
        }

        @Override
        public final Builder matchType(SearchContactsMatchType matchType) {
            this.matchType(matchType == null ? null : matchType.toString());
            return this;
        }

        public SearchableContactAttributes build() {
            return new SearchableContactAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchableContactAttributes> {
        public Builder criteria(Collection<SearchableContactAttributesCriteria> var1);

        public Builder criteria(SearchableContactAttributesCriteria ... var1);

        public Builder criteria(Consumer<SearchableContactAttributesCriteria.Builder> ... var1);

        public Builder matchType(String var1);

        public Builder matchType(SearchContactsMatchType var1);
    }
}

