/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.LexBotConfig;
import software.amazon.awssdk.services.connect.model.LexBotConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBotsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListBotsResponse> {
    private static final SdkField<List<LexBotConfig>> LEX_BOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LexBots").getter(ListBotsResponse.getter(ListBotsResponse::lexBots)).setter(ListBotsResponse.setter(Builder::lexBots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexBots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LexBotConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBotsResponse.getter(ListBotsResponse::nextToken)).setter(ListBotsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEX_BOTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBotsResponse.memberNameToFieldInitializer();
    private final List<LexBotConfig> lexBots;
    private final String nextToken;

    private ListBotsResponse(BuilderImpl builder) {
        super(builder);
        this.lexBots = builder.lexBots;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLexBots() {
        return this.lexBots != null && !(this.lexBots instanceof SdkAutoConstructList);
    }

    public final List<LexBotConfig> lexBots() {
        return this.lexBots;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLexBots() ? this.lexBots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotsResponse)) {
            return false;
        }
        ListBotsResponse other = (ListBotsResponse)((Object)obj);
        return this.hasLexBots() == other.hasLexBots() && Objects.equals(this.lexBots(), other.lexBots()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBotsResponse").add("LexBots", this.hasLexBots() ? this.lexBots() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LexBots": {
                return Optional.ofNullable(clazz.cast(this.lexBots()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LexBots", LEX_BOTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBotsResponse, T> g) {
        return obj -> g.apply((ListBotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<LexBotConfig> lexBots = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotsResponse model) {
            super(model);
            this.lexBots(model.lexBots);
            this.nextToken(model.nextToken);
        }

        public final List<LexBotConfig.Builder> getLexBots() {
            List<LexBotConfig.Builder> result = LexBotConfigListCopier.copyToBuilder(this.lexBots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLexBots(Collection<LexBotConfig.BuilderImpl> lexBots) {
            this.lexBots = LexBotConfigListCopier.copyFromBuilder(lexBots);
        }

        @Override
        public final Builder lexBots(Collection<LexBotConfig> lexBots) {
            this.lexBots = LexBotConfigListCopier.copy(lexBots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexBots(LexBotConfig ... lexBots) {
            this.lexBots(Arrays.asList(lexBots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexBots(Consumer<LexBotConfig.Builder> ... lexBots) {
            this.lexBots(Stream.of(lexBots).map(c -> (LexBotConfig)((LexBotConfig.Builder)LexBotConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBotsResponse build() {
            return new ListBotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBotsResponse> {
        public Builder lexBots(Collection<LexBotConfig> var1);

        public Builder lexBots(LexBotConfig ... var1);

        public Builder lexBots(Consumer<LexBotConfig.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

