/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.IpCidrListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAuthenticationProfileRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateAuthenticationProfileRequest> {
    private static final SdkField<String> AUTHENTICATION_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationProfileId").getter(UpdateAuthenticationProfileRequest.getter(UpdateAuthenticationProfileRequest::authenticationProfileId)).setter(UpdateAuthenticationProfileRequest.setter(Builder::authenticationProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AuthenticationProfileId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateAuthenticationProfileRequest.getter(UpdateAuthenticationProfileRequest::instanceId)).setter(UpdateAuthenticationProfileRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateAuthenticationProfileRequest.getter(UpdateAuthenticationProfileRequest::name)).setter(UpdateAuthenticationProfileRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateAuthenticationProfileRequest.getter(UpdateAuthenticationProfileRequest::description)).setter(UpdateAuthenticationProfileRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> ALLOWED_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedIps").getter(UpdateAuthenticationProfileRequest.getter(UpdateAuthenticationProfileRequest::allowedIps)).setter(UpdateAuthenticationProfileRequest.setter(Builder::allowedIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BLOCKED_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockedIps").getter(UpdateAuthenticationProfileRequest.getter(UpdateAuthenticationProfileRequest::blockedIps)).setter(UpdateAuthenticationProfileRequest.setter(Builder::blockedIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockedIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PERIODIC_SESSION_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PeriodicSessionDuration").getter(UpdateAuthenticationProfileRequest.getter(UpdateAuthenticationProfileRequest::periodicSessionDuration)).setter(UpdateAuthenticationProfileRequest.setter(Builder::periodicSessionDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodicSessionDuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_PROFILE_ID_FIELD, INSTANCE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ALLOWED_IPS_FIELD, BLOCKED_IPS_FIELD, PERIODIC_SESSION_DURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAuthenticationProfileRequest.memberNameToFieldInitializer();
    private final String authenticationProfileId;
    private final String instanceId;
    private final String name;
    private final String description;
    private final List<String> allowedIps;
    private final List<String> blockedIps;
    private final Integer periodicSessionDuration;

    private UpdateAuthenticationProfileRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationProfileId = builder.authenticationProfileId;
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.description = builder.description;
        this.allowedIps = builder.allowedIps;
        this.blockedIps = builder.blockedIps;
        this.periodicSessionDuration = builder.periodicSessionDuration;
    }

    public final String authenticationProfileId() {
        return this.authenticationProfileId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasAllowedIps() {
        return this.allowedIps != null && !(this.allowedIps instanceof SdkAutoConstructList);
    }

    public final List<String> allowedIps() {
        return this.allowedIps;
    }

    public final boolean hasBlockedIps() {
        return this.blockedIps != null && !(this.blockedIps instanceof SdkAutoConstructList);
    }

    public final List<String> blockedIps() {
        return this.blockedIps;
    }

    public final Integer periodicSessionDuration() {
        return this.periodicSessionDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedIps() ? this.allowedIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockedIps() ? this.blockedIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.periodicSessionDuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAuthenticationProfileRequest)) {
            return false;
        }
        UpdateAuthenticationProfileRequest other = (UpdateAuthenticationProfileRequest)((Object)obj);
        return Objects.equals(this.authenticationProfileId(), other.authenticationProfileId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasAllowedIps() == other.hasAllowedIps() && Objects.equals(this.allowedIps(), other.allowedIps()) && this.hasBlockedIps() == other.hasBlockedIps() && Objects.equals(this.blockedIps(), other.blockedIps()) && Objects.equals(this.periodicSessionDuration(), other.periodicSessionDuration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAuthenticationProfileRequest").add("AuthenticationProfileId", (Object)this.authenticationProfileId()).add("InstanceId", (Object)this.instanceId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("AllowedIps", this.hasAllowedIps() ? this.allowedIps() : null).add("BlockedIps", this.hasBlockedIps() ? this.blockedIps() : null).add("PeriodicSessionDuration", (Object)this.periodicSessionDuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationProfileId": {
                return Optional.ofNullable(clazz.cast(this.authenticationProfileId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AllowedIps": {
                return Optional.ofNullable(clazz.cast(this.allowedIps()));
            }
            case "BlockedIps": {
                return Optional.ofNullable(clazz.cast(this.blockedIps()));
            }
            case "PeriodicSessionDuration": {
                return Optional.ofNullable(clazz.cast(this.periodicSessionDuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AuthenticationProfileId", AUTHENTICATION_PROFILE_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AllowedIps", ALLOWED_IPS_FIELD);
        map.put("BlockedIps", BLOCKED_IPS_FIELD);
        map.put("PeriodicSessionDuration", PERIODIC_SESSION_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAuthenticationProfileRequest, T> g) {
        return obj -> g.apply((UpdateAuthenticationProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String authenticationProfileId;
        private String instanceId;
        private String name;
        private String description;
        private List<String> allowedIps = DefaultSdkAutoConstructList.getInstance();
        private List<String> blockedIps = DefaultSdkAutoConstructList.getInstance();
        private Integer periodicSessionDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAuthenticationProfileRequest model) {
            super(model);
            this.authenticationProfileId(model.authenticationProfileId);
            this.instanceId(model.instanceId);
            this.name(model.name);
            this.description(model.description);
            this.allowedIps(model.allowedIps);
            this.blockedIps(model.blockedIps);
            this.periodicSessionDuration(model.periodicSessionDuration);
        }

        public final String getAuthenticationProfileId() {
            return this.authenticationProfileId;
        }

        public final void setAuthenticationProfileId(String authenticationProfileId) {
            this.authenticationProfileId = authenticationProfileId;
        }

        @Override
        public final Builder authenticationProfileId(String authenticationProfileId) {
            this.authenticationProfileId = authenticationProfileId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getAllowedIps() {
            if (this.allowedIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedIps;
        }

        public final void setAllowedIps(Collection<String> allowedIps) {
            this.allowedIps = IpCidrListCopier.copy(allowedIps);
        }

        @Override
        public final Builder allowedIps(Collection<String> allowedIps) {
            this.allowedIps = IpCidrListCopier.copy(allowedIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedIps(String ... allowedIps) {
            this.allowedIps(Arrays.asList(allowedIps));
            return this;
        }

        public final Collection<String> getBlockedIps() {
            if (this.blockedIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.blockedIps;
        }

        public final void setBlockedIps(Collection<String> blockedIps) {
            this.blockedIps = IpCidrListCopier.copy(blockedIps);
        }

        @Override
        public final Builder blockedIps(Collection<String> blockedIps) {
            this.blockedIps = IpCidrListCopier.copy(blockedIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedIps(String ... blockedIps) {
            this.blockedIps(Arrays.asList(blockedIps));
            return this;
        }

        public final Integer getPeriodicSessionDuration() {
            return this.periodicSessionDuration;
        }

        public final void setPeriodicSessionDuration(Integer periodicSessionDuration) {
            this.periodicSessionDuration = periodicSessionDuration;
        }

        @Override
        public final Builder periodicSessionDuration(Integer periodicSessionDuration) {
            this.periodicSessionDuration = periodicSessionDuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAuthenticationProfileRequest build() {
            return new UpdateAuthenticationProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAuthenticationProfileRequest> {
        public Builder authenticationProfileId(String var1);

        public Builder instanceId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder allowedIps(Collection<String> var1);

        public Builder allowedIps(String ... var1);

        public Builder blockedIps(Collection<String> var1);

        public Builder blockedIps(String ... var1);

        public Builder periodicSessionDuration(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

