/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ParticipantCapabilities;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AllowedCapabilities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AllowedCapabilities> {
    private static final SdkField<ParticipantCapabilities> CUSTOMER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Customer").getter(AllowedCapabilities.getter(AllowedCapabilities::customer)).setter(AllowedCapabilities.setter(Builder::customer)).constructor(ParticipantCapabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()}).build();
    private static final SdkField<ParticipantCapabilities> AGENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Agent").getter(AllowedCapabilities.getter(AllowedCapabilities::agent)).setter(AllowedCapabilities.setter(Builder::agent)).constructor(ParticipantCapabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Agent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_FIELD, AGENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AllowedCapabilities.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ParticipantCapabilities customer;
    private final ParticipantCapabilities agent;

    private AllowedCapabilities(BuilderImpl builder) {
        this.customer = builder.customer;
        this.agent = builder.agent;
    }

    public final ParticipantCapabilities customer() {
        return this.customer;
    }

    public final ParticipantCapabilities agent() {
        return this.agent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customer());
        hashCode = 31 * hashCode + Objects.hashCode(this.agent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllowedCapabilities)) {
            return false;
        }
        AllowedCapabilities other = (AllowedCapabilities)obj;
        return Objects.equals(this.customer(), other.customer()) && Objects.equals(this.agent(), other.agent());
    }

    public final String toString() {
        return ToString.builder((String)"AllowedCapabilities").add("Customer", (Object)this.customer()).add("Agent", (Object)this.agent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Customer": {
                return Optional.ofNullable(clazz.cast(this.customer()));
            }
            case "Agent": {
                return Optional.ofNullable(clazz.cast(this.agent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<ParticipantCapabilities>> map = new HashMap<String, SdkField<ParticipantCapabilities>>();
        map.put("Customer", CUSTOMER_FIELD);
        map.put("Agent", AGENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AllowedCapabilities, T> g) {
        return obj -> g.apply((AllowedCapabilities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ParticipantCapabilities customer;
        private ParticipantCapabilities agent;

        private BuilderImpl() {
        }

        private BuilderImpl(AllowedCapabilities model) {
            this.customer(model.customer);
            this.agent(model.agent);
        }

        public final ParticipantCapabilities.Builder getCustomer() {
            return this.customer != null ? this.customer.toBuilder() : null;
        }

        public final void setCustomer(ParticipantCapabilities.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(ParticipantCapabilities customer) {
            this.customer = customer;
            return this;
        }

        public final ParticipantCapabilities.Builder getAgent() {
            return this.agent != null ? this.agent.toBuilder() : null;
        }

        public final void setAgent(ParticipantCapabilities.BuilderImpl agent) {
            this.agent = agent != null ? agent.build() : null;
        }

        @Override
        public final Builder agent(ParticipantCapabilities agent) {
            this.agent = agent;
            return this;
        }

        public AllowedCapabilities build() {
            return new AllowedCapabilities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AllowedCapabilities> {
        public Builder customer(ParticipantCapabilities var1);

        default public Builder customer(Consumer<ParticipantCapabilities.Builder> customer) {
            return this.customer((ParticipantCapabilities)((ParticipantCapabilities.Builder)ParticipantCapabilities.builder().applyMutation(customer)).build());
        }

        public Builder agent(ParticipantCapabilities var1);

        default public Builder agent(Consumer<ParticipantCapabilities.Builder> agent) {
            return this.agent((ParticipantCapabilities)((ParticipantCapabilities.Builder)ParticipantCapabilities.builder().applyMutation(agent)).build());
        }
    }
}

