/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectException;
import software.amazon.awssdk.services.connect.model.PropertyValidationExceptionProperty;
import software.amazon.awssdk.services.connect.model.PropertyValidationExceptionPropertyListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertyValidationException
extends ConnectException
implements ToCopyableBuilder<Builder, PropertyValidationException> {
    private static final SdkField<List<PropertyValidationExceptionProperty>> PROPERTY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PropertyList").getter(PropertyValidationException.getter(PropertyValidationException::propertyList)).setter(PropertyValidationException.setter(Builder::propertyList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyValidationExceptionProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PropertyValidationException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<PropertyValidationExceptionProperty> propertyList;

    private PropertyValidationException(BuilderImpl builder) {
        super(builder);
        this.propertyList = builder.propertyList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public boolean hasPropertyList() {
        return this.propertyList != null && !(this.propertyList instanceof SdkAutoConstructList);
    }

    public List<PropertyValidationExceptionProperty> propertyList() {
        return this.propertyList;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<PropertyValidationExceptionProperty>>> map = new HashMap<String, SdkField<List<PropertyValidationExceptionProperty>>>();
        map.put("PropertyList", PROPERTY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PropertyValidationException, T> g) {
        return obj -> g.apply((PropertyValidationException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectException.BuilderImpl
    implements Builder {
        private List<PropertyValidationExceptionProperty> propertyList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyValidationException model) {
            super(model);
            this.propertyList(model.propertyList);
        }

        public final List<PropertyValidationExceptionProperty.Builder> getPropertyList() {
            List<PropertyValidationExceptionProperty.Builder> result = PropertyValidationExceptionPropertyListCopier.copyToBuilder(this.propertyList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertyList(Collection<PropertyValidationExceptionProperty.BuilderImpl> propertyList) {
            this.propertyList = PropertyValidationExceptionPropertyListCopier.copyFromBuilder(propertyList);
        }

        @Override
        public final Builder propertyList(Collection<PropertyValidationExceptionProperty> propertyList) {
            this.propertyList = PropertyValidationExceptionPropertyListCopier.copy(propertyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyList(PropertyValidationExceptionProperty ... propertyList) {
            this.propertyList(Arrays.asList(propertyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyList(Consumer<PropertyValidationExceptionProperty.Builder> ... propertyList) {
            this.propertyList(Stream.of(propertyList).map(c -> (PropertyValidationExceptionProperty)((PropertyValidationExceptionProperty.Builder)PropertyValidationExceptionProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public PropertyValidationException build() {
            return new PropertyValidationException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertyValidationException>,
    ConnectException.Builder {
        public Builder propertyList(Collection<PropertyValidationExceptionProperty> var1);

        public Builder propertyList(PropertyValidationExceptionProperty ... var1);

        public Builder propertyList(Consumer<PropertyValidationExceptionProperty.Builder> ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);

        @Override
        public Builder numAttempts(Integer var1);
    }
}

