/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.Application;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileApplicationsRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileApplicationsResponse;

public class ListSecurityProfileApplicationsIterable
implements SdkIterable<ListSecurityProfileApplicationsResponse> {
    private final ConnectClient client;
    private final ListSecurityProfileApplicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSecurityProfileApplicationsIterable(ConnectClient client, ListSecurityProfileApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSecurityProfileApplicationsResponseFetcher();
    }

    public Iterator<ListSecurityProfileApplicationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Application> applications() {
        Function<ListSecurityProfileApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.applications() != null) {
                return response.applications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSecurityProfileApplicationsResponseFetcher
    implements SyncPageFetcher<ListSecurityProfileApplicationsResponse> {
        private ListSecurityProfileApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityProfileApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSecurityProfileApplicationsResponse nextPage(ListSecurityProfileApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityProfileApplicationsIterable.this.client.listSecurityProfileApplications(ListSecurityProfileApplicationsIterable.this.firstRequest);
            }
            return ListSecurityProfileApplicationsIterable.this.client.listSecurityProfileApplications((ListSecurityProfileApplicationsRequest)((Object)ListSecurityProfileApplicationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

