/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.PromptSummary;
import software.amazon.awssdk.services.connect.model.PromptSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPromptsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListPromptsResponse> {
    private static final SdkField<List<PromptSummary>> PROMPT_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PromptSummaryList").getter(ListPromptsResponse.getter(ListPromptsResponse::promptSummaryList)).setter(ListPromptsResponse.setter(Builder::promptSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromptSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PromptSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPromptsResponse.getter(ListPromptsResponse::nextToken)).setter(ListPromptsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPromptsResponse.memberNameToFieldInitializer();
    private final List<PromptSummary> promptSummaryList;
    private final String nextToken;

    private ListPromptsResponse(BuilderImpl builder) {
        super(builder);
        this.promptSummaryList = builder.promptSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPromptSummaryList() {
        return this.promptSummaryList != null && !(this.promptSummaryList instanceof SdkAutoConstructList);
    }

    public final List<PromptSummary> promptSummaryList() {
        return this.promptSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPromptSummaryList() ? this.promptSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPromptsResponse)) {
            return false;
        }
        ListPromptsResponse other = (ListPromptsResponse)((Object)obj);
        return this.hasPromptSummaryList() == other.hasPromptSummaryList() && Objects.equals(this.promptSummaryList(), other.promptSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPromptsResponse").add("PromptSummaryList", this.hasPromptSummaryList() ? this.promptSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PromptSummaryList": {
                return Optional.ofNullable(clazz.cast(this.promptSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PromptSummaryList", PROMPT_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPromptsResponse, T> g) {
        return obj -> g.apply((ListPromptsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<PromptSummary> promptSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPromptsResponse model) {
            super(model);
            this.promptSummaryList(model.promptSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<PromptSummary.Builder> getPromptSummaryList() {
            List<PromptSummary.Builder> result = PromptSummaryListCopier.copyToBuilder(this.promptSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPromptSummaryList(Collection<PromptSummary.BuilderImpl> promptSummaryList) {
            this.promptSummaryList = PromptSummaryListCopier.copyFromBuilder(promptSummaryList);
        }

        @Override
        public final Builder promptSummaryList(Collection<PromptSummary> promptSummaryList) {
            this.promptSummaryList = PromptSummaryListCopier.copy(promptSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder promptSummaryList(PromptSummary ... promptSummaryList) {
            this.promptSummaryList(Arrays.asList(promptSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder promptSummaryList(Consumer<PromptSummary.Builder> ... promptSummaryList) {
            this.promptSummaryList(Stream.of(promptSummaryList).map(c -> (PromptSummary)((PromptSummary.Builder)PromptSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPromptsResponse build() {
            return new ListPromptsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPromptsResponse> {
        public Builder promptSummaryList(Collection<PromptSummary> var1);

        public Builder promptSummaryList(PromptSummary ... var1);

        public Builder promptSummaryList(Consumer<PromptSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

