/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.EvaluationFormVersionSummary;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsResponse;

public class ListEvaluationFormVersionsPublisher
implements SdkPublisher<ListEvaluationFormVersionsResponse> {
    private final ConnectAsyncClient client;
    private final ListEvaluationFormVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEvaluationFormVersionsPublisher(ConnectAsyncClient client, ListEvaluationFormVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEvaluationFormVersionsPublisher(ConnectAsyncClient client, ListEvaluationFormVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEvaluationFormVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEvaluationFormVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EvaluationFormVersionSummary> evaluationFormVersionSummaryList() {
        Function<ListEvaluationFormVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.evaluationFormVersionSummaryList() != null) {
                return response.evaluationFormVersionSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEvaluationFormVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEvaluationFormVersionsResponseFetcher
    implements AsyncPageFetcher<ListEvaluationFormVersionsResponse> {
        private ListEvaluationFormVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEvaluationFormVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEvaluationFormVersionsResponse> nextPage(ListEvaluationFormVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListEvaluationFormVersionsPublisher.this.client.listEvaluationFormVersions(ListEvaluationFormVersionsPublisher.this.firstRequest);
            }
            return ListEvaluationFormVersionsPublisher.this.client.listEvaluationFormVersions((ListEvaluationFormVersionsRequest)((Object)ListEvaluationFormVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

