/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAttachedFileRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, GetAttachedFileRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(GetAttachedFileRequest.getter(GetAttachedFileRequest::instanceId)).setter(GetAttachedFileRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> FILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileId").getter(GetAttachedFileRequest.getter(GetAttachedFileRequest::fileId)).setter(GetAttachedFileRequest.setter(Builder::fileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FileId").build()}).build();
    private static final SdkField<Integer> URL_EXPIRY_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UrlExpiryInSeconds").getter(GetAttachedFileRequest.getter(GetAttachedFileRequest::urlExpiryInSeconds)).setter(GetAttachedFileRequest.setter(Builder::urlExpiryInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("urlExpiryInSeconds").build()}).build();
    private static final SdkField<String> ASSOCIATED_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedResourceArn").getter(GetAttachedFileRequest.getter(GetAttachedFileRequest::associatedResourceArn)).setter(GetAttachedFileRequest.setter(Builder::associatedResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("associatedResourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, FILE_ID_FIELD, URL_EXPIRY_IN_SECONDS_FIELD, ASSOCIATED_RESOURCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAttachedFileRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String fileId;
    private final Integer urlExpiryInSeconds;
    private final String associatedResourceArn;

    private GetAttachedFileRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.fileId = builder.fileId;
        this.urlExpiryInSeconds = builder.urlExpiryInSeconds;
        this.associatedResourceArn = builder.associatedResourceArn;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String fileId() {
        return this.fileId;
    }

    public final Integer urlExpiryInSeconds() {
        return this.urlExpiryInSeconds;
    }

    public final String associatedResourceArn() {
        return this.associatedResourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.urlExpiryInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedResourceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAttachedFileRequest)) {
            return false;
        }
        GetAttachedFileRequest other = (GetAttachedFileRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.fileId(), other.fileId()) && Objects.equals(this.urlExpiryInSeconds(), other.urlExpiryInSeconds()) && Objects.equals(this.associatedResourceArn(), other.associatedResourceArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetAttachedFileRequest").add("InstanceId", (Object)this.instanceId()).add("FileId", (Object)this.fileId()).add("UrlExpiryInSeconds", (Object)this.urlExpiryInSeconds()).add("AssociatedResourceArn", (Object)this.associatedResourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "FileId": {
                return Optional.ofNullable(clazz.cast(this.fileId()));
            }
            case "UrlExpiryInSeconds": {
                return Optional.ofNullable(clazz.cast(this.urlExpiryInSeconds()));
            }
            case "AssociatedResourceArn": {
                return Optional.ofNullable(clazz.cast(this.associatedResourceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("FileId", FILE_ID_FIELD);
        map.put("urlExpiryInSeconds", URL_EXPIRY_IN_SECONDS_FIELD);
        map.put("associatedResourceArn", ASSOCIATED_RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAttachedFileRequest, T> g) {
        return obj -> g.apply((GetAttachedFileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String fileId;
        private Integer urlExpiryInSeconds;
        private String associatedResourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAttachedFileRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.fileId(model.fileId);
            this.urlExpiryInSeconds(model.urlExpiryInSeconds);
            this.associatedResourceArn(model.associatedResourceArn);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getFileId() {
            return this.fileId;
        }

        public final void setFileId(String fileId) {
            this.fileId = fileId;
        }

        @Override
        public final Builder fileId(String fileId) {
            this.fileId = fileId;
            return this;
        }

        public final Integer getUrlExpiryInSeconds() {
            return this.urlExpiryInSeconds;
        }

        public final void setUrlExpiryInSeconds(Integer urlExpiryInSeconds) {
            this.urlExpiryInSeconds = urlExpiryInSeconds;
        }

        @Override
        public final Builder urlExpiryInSeconds(Integer urlExpiryInSeconds) {
            this.urlExpiryInSeconds = urlExpiryInSeconds;
            return this;
        }

        public final String getAssociatedResourceArn() {
            return this.associatedResourceArn;
        }

        public final void setAssociatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
        }

        @Override
        public final Builder associatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAttachedFileRequest build() {
            return new GetAttachedFileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAttachedFileRequest> {
        public Builder instanceId(String var1);

        public Builder fileId(String var1);

        public Builder urlExpiryInSeconds(Integer var1);

        public Builder associatedResourceArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

