/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePromptResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, CreatePromptResponse> {
    private static final SdkField<String> PROMPT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PromptARN").getter(CreatePromptResponse.getter(CreatePromptResponse::promptARN)).setter(CreatePromptResponse.setter(Builder::promptARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromptARN").build()}).build();
    private static final SdkField<String> PROMPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PromptId").getter(CreatePromptResponse.getter(CreatePromptResponse::promptId)).setter(CreatePromptResponse.setter(Builder::promptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromptId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_ARN_FIELD, PROMPT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PromptARN", PROMPT_ARN_FIELD);
            this.put("PromptId", PROMPT_ID_FIELD);
        }
    });
    private final String promptARN;
    private final String promptId;

    private CreatePromptResponse(BuilderImpl builder) {
        super(builder);
        this.promptARN = builder.promptARN;
        this.promptId = builder.promptId;
    }

    public final String promptARN() {
        return this.promptARN;
    }

    public final String promptId() {
        return this.promptId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.promptARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePromptResponse)) {
            return false;
        }
        CreatePromptResponse other = (CreatePromptResponse)((Object)obj);
        return Objects.equals(this.promptARN(), other.promptARN()) && Objects.equals(this.promptId(), other.promptId());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePromptResponse").add("PromptARN", (Object)this.promptARN()).add("PromptId", (Object)this.promptId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PromptARN": {
                return Optional.ofNullable(clazz.cast(this.promptARN()));
            }
            case "PromptId": {
                return Optional.ofNullable(clazz.cast(this.promptId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreatePromptResponse, T> g) {
        return obj -> g.apply((CreatePromptResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String promptARN;
        private String promptId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePromptResponse model) {
            super(model);
            this.promptARN(model.promptARN);
            this.promptId(model.promptId);
        }

        public final String getPromptARN() {
            return this.promptARN;
        }

        public final void setPromptARN(String promptARN) {
            this.promptARN = promptARN;
        }

        @Override
        public final Builder promptARN(String promptARN) {
            this.promptARN = promptARN;
            return this;
        }

        public final String getPromptId() {
            return this.promptId;
        }

        public final void setPromptId(String promptId) {
            this.promptId = promptId;
        }

        @Override
        public final Builder promptId(String promptId) {
            this.promptId = promptId;
            return this;
        }

        @Override
        public CreatePromptResponse build() {
            return new CreatePromptResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePromptResponse> {
        public Builder promptARN(String var1);

        public Builder promptId(String var1);
    }
}

