/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.Channel;
import software.amazon.awssdk.services.connect.model.ContactInitiationMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociatedContactSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociatedContactSummary> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(AssociatedContactSummary.getter(AssociatedContactSummary::contactId)).setter(AssociatedContactSummary.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactArn").getter(AssociatedContactSummary.getter(AssociatedContactSummary::contactArn)).setter(AssociatedContactSummary.setter(Builder::contactArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()}).build();
    private static final SdkField<Instant> INITIATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InitiationTimestamp").getter(AssociatedContactSummary.getter(AssociatedContactSummary::initiationTimestamp)).setter(AssociatedContactSummary.setter(Builder::initiationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationTimestamp").build()}).build();
    private static final SdkField<Instant> DISCONNECT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DisconnectTimestamp").getter(AssociatedContactSummary.getter(AssociatedContactSummary::disconnectTimestamp)).setter(AssociatedContactSummary.setter(Builder::disconnectTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectTimestamp").build()}).build();
    private static final SdkField<String> INITIAL_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitialContactId").getter(AssociatedContactSummary.getter(AssociatedContactSummary::initialContactId)).setter(AssociatedContactSummary.setter(Builder::initialContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialContactId").build()}).build();
    private static final SdkField<String> PREVIOUS_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviousContactId").getter(AssociatedContactSummary.getter(AssociatedContactSummary::previousContactId)).setter(AssociatedContactSummary.setter(Builder::previousContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousContactId").build()}).build();
    private static final SdkField<String> RELATED_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelatedContactId").getter(AssociatedContactSummary.getter(AssociatedContactSummary::relatedContactId)).setter(AssociatedContactSummary.setter(Builder::relatedContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedContactId").build()}).build();
    private static final SdkField<String> INITIATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitiationMethod").getter(AssociatedContactSummary.getter(AssociatedContactSummary::initiationMethodAsString)).setter(AssociatedContactSummary.setter(Builder::initiationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationMethod").build()}).build();
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Channel").getter(AssociatedContactSummary.getter(AssociatedContactSummary::channelAsString)).setter(AssociatedContactSummary.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD, CONTACT_ARN_FIELD, INITIATION_TIMESTAMP_FIELD, DISCONNECT_TIMESTAMP_FIELD, INITIAL_CONTACT_ID_FIELD, PREVIOUS_CONTACT_ID_FIELD, RELATED_CONTACT_ID_FIELD, INITIATION_METHOD_FIELD, CHANNEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ContactId", CONTACT_ID_FIELD);
            this.put("ContactArn", CONTACT_ARN_FIELD);
            this.put("InitiationTimestamp", INITIATION_TIMESTAMP_FIELD);
            this.put("DisconnectTimestamp", DISCONNECT_TIMESTAMP_FIELD);
            this.put("InitialContactId", INITIAL_CONTACT_ID_FIELD);
            this.put("PreviousContactId", PREVIOUS_CONTACT_ID_FIELD);
            this.put("RelatedContactId", RELATED_CONTACT_ID_FIELD);
            this.put("InitiationMethod", INITIATION_METHOD_FIELD);
            this.put("Channel", CHANNEL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String contactId;
    private final String contactArn;
    private final Instant initiationTimestamp;
    private final Instant disconnectTimestamp;
    private final String initialContactId;
    private final String previousContactId;
    private final String relatedContactId;
    private final String initiationMethod;
    private final String channel;

    private AssociatedContactSummary(BuilderImpl builder) {
        this.contactId = builder.contactId;
        this.contactArn = builder.contactArn;
        this.initiationTimestamp = builder.initiationTimestamp;
        this.disconnectTimestamp = builder.disconnectTimestamp;
        this.initialContactId = builder.initialContactId;
        this.previousContactId = builder.previousContactId;
        this.relatedContactId = builder.relatedContactId;
        this.initiationMethod = builder.initiationMethod;
        this.channel = builder.channel;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final String contactArn() {
        return this.contactArn;
    }

    public final Instant initiationTimestamp() {
        return this.initiationTimestamp;
    }

    public final Instant disconnectTimestamp() {
        return this.disconnectTimestamp;
    }

    public final String initialContactId() {
        return this.initialContactId;
    }

    public final String previousContactId() {
        return this.previousContactId;
    }

    public final String relatedContactId() {
        return this.relatedContactId;
    }

    public final ContactInitiationMethod initiationMethod() {
        return ContactInitiationMethod.fromValue(this.initiationMethod);
    }

    public final String initiationMethodAsString() {
        return this.initiationMethod;
    }

    public final Channel channel() {
        return Channel.fromValue(this.channel);
    }

    public final String channelAsString() {
        return this.channel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.disconnectTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiationMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedContactSummary)) {
            return false;
        }
        AssociatedContactSummary other = (AssociatedContactSummary)obj;
        return Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.contactArn(), other.contactArn()) && Objects.equals(this.initiationTimestamp(), other.initiationTimestamp()) && Objects.equals(this.disconnectTimestamp(), other.disconnectTimestamp()) && Objects.equals(this.initialContactId(), other.initialContactId()) && Objects.equals(this.previousContactId(), other.previousContactId()) && Objects.equals(this.relatedContactId(), other.relatedContactId()) && Objects.equals(this.initiationMethodAsString(), other.initiationMethodAsString()) && Objects.equals(this.channelAsString(), other.channelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AssociatedContactSummary").add("ContactId", (Object)this.contactId()).add("ContactArn", (Object)this.contactArn()).add("InitiationTimestamp", (Object)this.initiationTimestamp()).add("DisconnectTimestamp", (Object)this.disconnectTimestamp()).add("InitialContactId", (Object)this.initialContactId()).add("PreviousContactId", (Object)this.previousContactId()).add("RelatedContactId", (Object)this.relatedContactId()).add("InitiationMethod", (Object)this.initiationMethodAsString()).add("Channel", (Object)this.channelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "ContactArn": {
                return Optional.ofNullable(clazz.cast(this.contactArn()));
            }
            case "InitiationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.initiationTimestamp()));
            }
            case "DisconnectTimestamp": {
                return Optional.ofNullable(clazz.cast(this.disconnectTimestamp()));
            }
            case "InitialContactId": {
                return Optional.ofNullable(clazz.cast(this.initialContactId()));
            }
            case "PreviousContactId": {
                return Optional.ofNullable(clazz.cast(this.previousContactId()));
            }
            case "RelatedContactId": {
                return Optional.ofNullable(clazz.cast(this.relatedContactId()));
            }
            case "InitiationMethod": {
                return Optional.ofNullable(clazz.cast(this.initiationMethodAsString()));
            }
            case "Channel": {
                return Optional.ofNullable(clazz.cast(this.channelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssociatedContactSummary, T> g) {
        return obj -> g.apply((AssociatedContactSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contactId;
        private String contactArn;
        private Instant initiationTimestamp;
        private Instant disconnectTimestamp;
        private String initialContactId;
        private String previousContactId;
        private String relatedContactId;
        private String initiationMethod;
        private String channel;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedContactSummary model) {
            this.contactId(model.contactId);
            this.contactArn(model.contactArn);
            this.initiationTimestamp(model.initiationTimestamp);
            this.disconnectTimestamp(model.disconnectTimestamp);
            this.initialContactId(model.initialContactId);
            this.previousContactId(model.previousContactId);
            this.relatedContactId(model.relatedContactId);
            this.initiationMethod(model.initiationMethod);
            this.channel(model.channel);
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getContactArn() {
            return this.contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final Instant getInitiationTimestamp() {
            return this.initiationTimestamp;
        }

        public final void setInitiationTimestamp(Instant initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
        }

        @Override
        public final Builder initiationTimestamp(Instant initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
            return this;
        }

        public final Instant getDisconnectTimestamp() {
            return this.disconnectTimestamp;
        }

        public final void setDisconnectTimestamp(Instant disconnectTimestamp) {
            this.disconnectTimestamp = disconnectTimestamp;
        }

        @Override
        public final Builder disconnectTimestamp(Instant disconnectTimestamp) {
            this.disconnectTimestamp = disconnectTimestamp;
            return this;
        }

        public final String getInitialContactId() {
            return this.initialContactId;
        }

        public final void setInitialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
        }

        @Override
        public final Builder initialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
            return this;
        }

        public final String getPreviousContactId() {
            return this.previousContactId;
        }

        public final void setPreviousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
        }

        @Override
        public final Builder previousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
            return this;
        }

        public final String getRelatedContactId() {
            return this.relatedContactId;
        }

        public final void setRelatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
        }

        @Override
        public final Builder relatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
            return this;
        }

        public final String getInitiationMethod() {
            return this.initiationMethod;
        }

        public final void setInitiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
        }

        @Override
        public final Builder initiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
            return this;
        }

        @Override
        public final Builder initiationMethod(ContactInitiationMethod initiationMethod) {
            this.initiationMethod(initiationMethod == null ? null : initiationMethod.toString());
            return this;
        }

        public final String getChannel() {
            return this.channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public AssociatedContactSummary build() {
            return new AssociatedContactSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociatedContactSummary> {
        public Builder contactId(String var1);

        public Builder contactArn(String var1);

        public Builder initiationTimestamp(Instant var1);

        public Builder disconnectTimestamp(Instant var1);

        public Builder initialContactId(String var1);

        public Builder previousContactId(String var1);

        public Builder relatedContactId(String var1);

        public Builder initiationMethod(String var1);

        public Builder initiationMethod(ContactInitiationMethod var1);

        public Builder channel(String var1);

        public Builder channel(Channel var1);
    }
}

