/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.RuleSummary;
import software.amazon.awssdk.services.connect.model.RuleSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRulesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListRulesResponse> {
    private static final SdkField<List<RuleSummary>> RULE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleSummaryList").getter(ListRulesResponse.getter(ListRulesResponse::ruleSummaryList)).setter(ListRulesResponse.setter(Builder::ruleSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRulesResponse.getter(ListRulesResponse::nextToken)).setter(ListRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RuleSummaryList", RULE_SUMMARY_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<RuleSummary> ruleSummaryList;
    private final String nextToken;

    private ListRulesResponse(BuilderImpl builder) {
        super(builder);
        this.ruleSummaryList = builder.ruleSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRuleSummaryList() {
        return this.ruleSummaryList != null && !(this.ruleSummaryList instanceof SdkAutoConstructList);
    }

    public final List<RuleSummary> ruleSummaryList() {
        return this.ruleSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleSummaryList() ? this.ruleSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRulesResponse)) {
            return false;
        }
        ListRulesResponse other = (ListRulesResponse)((Object)obj);
        return this.hasRuleSummaryList() == other.hasRuleSummaryList() && Objects.equals(this.ruleSummaryList(), other.ruleSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRulesResponse").add("RuleSummaryList", this.hasRuleSummaryList() ? this.ruleSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleSummaryList": {
                return Optional.ofNullable(clazz.cast(this.ruleSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRulesResponse, T> g) {
        return obj -> g.apply((ListRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<RuleSummary> ruleSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRulesResponse model) {
            super(model);
            this.ruleSummaryList(model.ruleSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<RuleSummary.Builder> getRuleSummaryList() {
            List<RuleSummary.Builder> result = RuleSummaryListCopier.copyToBuilder(this.ruleSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleSummaryList(Collection<RuleSummary.BuilderImpl> ruleSummaryList) {
            this.ruleSummaryList = RuleSummaryListCopier.copyFromBuilder(ruleSummaryList);
        }

        @Override
        public final Builder ruleSummaryList(Collection<RuleSummary> ruleSummaryList) {
            this.ruleSummaryList = RuleSummaryListCopier.copy(ruleSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSummaryList(RuleSummary ... ruleSummaryList) {
            this.ruleSummaryList(Arrays.asList(ruleSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSummaryList(Consumer<RuleSummary.Builder> ... ruleSummaryList) {
            this.ruleSummaryList(Stream.of(ruleSummaryList).map(c -> (RuleSummary)((RuleSummary.Builder)RuleSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRulesResponse build() {
            return new ListRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRulesResponse> {
        public Builder ruleSummaryList(Collection<RuleSummary> var1);

        public Builder ruleSummaryList(RuleSummary ... var1);

        public Builder ruleSummaryList(Consumer<RuleSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

