/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.ReferenceType;
import software.amazon.awssdk.services.connect.model.ReferenceTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContactReferencesRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, ListContactReferencesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ListContactReferencesRequest.getter(ListContactReferencesRequest::instanceId)).setter(ListContactReferencesRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(ListContactReferencesRequest.getter(ListContactReferencesRequest::contactId)).setter(ListContactReferencesRequest.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactId").build()}).build();
    private static final SdkField<List<String>> REFERENCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReferenceTypes").getter(ListContactReferencesRequest.getter(ListContactReferencesRequest::referenceTypesAsStrings)).setter(ListContactReferencesRequest.setter(Builder::referenceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("referenceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListContactReferencesRequest.getter(ListContactReferencesRequest::nextToken)).setter(ListContactReferencesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CONTACT_ID_FIELD, REFERENCE_TYPES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceId", INSTANCE_ID_FIELD);
            this.put("ContactId", CONTACT_ID_FIELD);
            this.put("referenceTypes", REFERENCE_TYPES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String instanceId;
    private final String contactId;
    private final List<String> referenceTypes;
    private final String nextToken;

    private ListContactReferencesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactId = builder.contactId;
        this.referenceTypes = builder.referenceTypes;
        this.nextToken = builder.nextToken;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final List<ReferenceType> referenceTypes() {
        return ReferenceTypesCopier.copyStringToEnum(this.referenceTypes);
    }

    public final boolean hasReferenceTypes() {
        return this.referenceTypes != null && !(this.referenceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> referenceTypesAsStrings() {
        return this.referenceTypes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceTypes() ? this.referenceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactReferencesRequest)) {
            return false;
        }
        ListContactReferencesRequest other = (ListContactReferencesRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.contactId(), other.contactId()) && this.hasReferenceTypes() == other.hasReferenceTypes() && Objects.equals(this.referenceTypesAsStrings(), other.referenceTypesAsStrings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListContactReferencesRequest").add("InstanceId", (Object)this.instanceId()).add("ContactId", (Object)this.contactId()).add("ReferenceTypes", this.hasReferenceTypes() ? this.referenceTypesAsStrings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "ReferenceTypes": {
                return Optional.ofNullable(clazz.cast(this.referenceTypesAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListContactReferencesRequest, T> g) {
        return obj -> g.apply((ListContactReferencesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String contactId;
        private List<String> referenceTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactReferencesRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.contactId(model.contactId);
            this.referenceTypesWithStrings(model.referenceTypes);
            this.nextToken(model.nextToken);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final Collection<String> getReferenceTypes() {
            if (this.referenceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.referenceTypes;
        }

        public final void setReferenceTypes(Collection<String> referenceTypes) {
            this.referenceTypes = ReferenceTypesCopier.copy(referenceTypes);
        }

        @Override
        public final Builder referenceTypesWithStrings(Collection<String> referenceTypes) {
            this.referenceTypes = ReferenceTypesCopier.copy(referenceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceTypesWithStrings(String ... referenceTypes) {
            this.referenceTypesWithStrings(Arrays.asList(referenceTypes));
            return this;
        }

        @Override
        public final Builder referenceTypes(Collection<ReferenceType> referenceTypes) {
            this.referenceTypes = ReferenceTypesCopier.copyEnumToString(referenceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceTypes(ReferenceType ... referenceTypes) {
            this.referenceTypes(Arrays.asList(referenceTypes));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListContactReferencesRequest build() {
            return new ListContactReferencesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContactReferencesRequest> {
        public Builder instanceId(String var1);

        public Builder contactId(String var1);

        public Builder referenceTypesWithStrings(Collection<String> var1);

        public Builder referenceTypesWithStrings(String ... var1);

        public Builder referenceTypes(Collection<ReferenceType> var1);

        public Builder referenceTypes(ReferenceType ... var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

