/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest;
import software.amazon.awssdk.services.connect.model.ListApprovedOriginsResponse;

public class ListApprovedOriginsPublisher
implements SdkPublisher<ListApprovedOriginsResponse> {
    private final ConnectAsyncClient client;
    private final ListApprovedOriginsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApprovedOriginsPublisher(ConnectAsyncClient client, ListApprovedOriginsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApprovedOriginsPublisher(ConnectAsyncClient client, ListApprovedOriginsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApprovedOriginsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApprovedOriginsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> origins() {
        Function<ListApprovedOriginsResponse, Iterator> getIterator = response -> {
            if (response != null && response.origins() != null) {
                return response.origins().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListApprovedOriginsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApprovedOriginsResponseFetcher
    implements AsyncPageFetcher<ListApprovedOriginsResponse> {
        private ListApprovedOriginsResponseFetcher() {
        }

        public boolean hasNextPage(ListApprovedOriginsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApprovedOriginsResponse> nextPage(ListApprovedOriginsResponse previousPage) {
            if (previousPage == null) {
                return ListApprovedOriginsPublisher.this.client.listApprovedOrigins(ListApprovedOriginsPublisher.this.firstRequest);
            }
            return ListApprovedOriginsPublisher.this.client.listApprovedOrigins((ListApprovedOriginsRequest)((Object)ListApprovedOriginsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

