/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AttributesCopier;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.ContactReferencesCopier;
import software.amazon.awssdk.services.connect.model.Reference;
import software.amazon.awssdk.services.connect.model.SegmentAttributeValue;
import software.amazon.awssdk.services.connect.model.SegmentAttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTaskContactRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, StartTaskContactRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(StartTaskContactRequest.getter(StartTaskContactRequest::instanceId)).setter(StartTaskContactRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> PREVIOUS_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviousContactId").getter(StartTaskContactRequest.getter(StartTaskContactRequest::previousContactId)).setter(StartTaskContactRequest.setter(Builder::previousContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousContactId").build()}).build();
    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactFlowId").getter(StartTaskContactRequest.getter(StartTaskContactRequest::contactFlowId)).setter(StartTaskContactRequest.setter(Builder::contactFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(StartTaskContactRequest.getter(StartTaskContactRequest::attributes)).setter(StartTaskContactRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StartTaskContactRequest.getter(StartTaskContactRequest::name)).setter(StartTaskContactRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Map<String, Reference>> REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("References").getter(StartTaskContactRequest.getter(StartTaskContactRequest::references)).setter(StartTaskContactRequest.setter(Builder::references)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("References").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Reference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StartTaskContactRequest.getter(StartTaskContactRequest::description)).setter(StartTaskContactRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartTaskContactRequest.getter(StartTaskContactRequest::clientToken)).setter(StartTaskContactRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Instant> SCHEDULED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScheduledTime").getter(StartTaskContactRequest.getter(StartTaskContactRequest::scheduledTime)).setter(StartTaskContactRequest.setter(Builder::scheduledTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTime").build()}).build();
    private static final SdkField<String> TASK_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskTemplateId").getter(StartTaskContactRequest.getter(StartTaskContactRequest::taskTemplateId)).setter(StartTaskContactRequest.setter(Builder::taskTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskTemplateId").build()}).build();
    private static final SdkField<String> QUICK_CONNECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuickConnectId").getter(StartTaskContactRequest.getter(StartTaskContactRequest::quickConnectId)).setter(StartTaskContactRequest.setter(Builder::quickConnectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectId").build()}).build();
    private static final SdkField<String> RELATED_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelatedContactId").getter(StartTaskContactRequest.getter(StartTaskContactRequest::relatedContactId)).setter(StartTaskContactRequest.setter(Builder::relatedContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedContactId").build()}).build();
    private static final SdkField<Map<String, SegmentAttributeValue>> SEGMENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SegmentAttributes").getter(StartTaskContactRequest.getter(StartTaskContactRequest::segmentAttributes)).setter(StartTaskContactRequest.setter(Builder::segmentAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SegmentAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, PREVIOUS_CONTACT_ID_FIELD, CONTACT_FLOW_ID_FIELD, ATTRIBUTES_FIELD, NAME_FIELD, REFERENCES_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, SCHEDULED_TIME_FIELD, TASK_TEMPLATE_ID_FIELD, QUICK_CONNECT_ID_FIELD, RELATED_CONTACT_ID_FIELD, SEGMENT_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceId", INSTANCE_ID_FIELD);
            this.put("PreviousContactId", PREVIOUS_CONTACT_ID_FIELD);
            this.put("ContactFlowId", CONTACT_FLOW_ID_FIELD);
            this.put("Attributes", ATTRIBUTES_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("References", REFERENCES_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("ScheduledTime", SCHEDULED_TIME_FIELD);
            this.put("TaskTemplateId", TASK_TEMPLATE_ID_FIELD);
            this.put("QuickConnectId", QUICK_CONNECT_ID_FIELD);
            this.put("RelatedContactId", RELATED_CONTACT_ID_FIELD);
            this.put("SegmentAttributes", SEGMENT_ATTRIBUTES_FIELD);
        }
    });
    private final String instanceId;
    private final String previousContactId;
    private final String contactFlowId;
    private final Map<String, String> attributes;
    private final String name;
    private final Map<String, Reference> references;
    private final String description;
    private final String clientToken;
    private final Instant scheduledTime;
    private final String taskTemplateId;
    private final String quickConnectId;
    private final String relatedContactId;
    private final Map<String, SegmentAttributeValue> segmentAttributes;

    private StartTaskContactRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.previousContactId = builder.previousContactId;
        this.contactFlowId = builder.contactFlowId;
        this.attributes = builder.attributes;
        this.name = builder.name;
        this.references = builder.references;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.scheduledTime = builder.scheduledTime;
        this.taskTemplateId = builder.taskTemplateId;
        this.quickConnectId = builder.quickConnectId;
        this.relatedContactId = builder.relatedContactId;
        this.segmentAttributes = builder.segmentAttributes;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String previousContactId() {
        return this.previousContactId;
    }

    public final String contactFlowId() {
        return this.contactFlowId;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasReferences() {
        return this.references != null && !(this.references instanceof SdkAutoConstructMap);
    }

    public final Map<String, Reference> references() {
        return this.references;
    }

    public final String description() {
        return this.description;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Instant scheduledTime() {
        return this.scheduledTime;
    }

    public final String taskTemplateId() {
        return this.taskTemplateId;
    }

    public final String quickConnectId() {
        return this.quickConnectId;
    }

    public final String relatedContactId() {
        return this.relatedContactId;
    }

    public final boolean hasSegmentAttributes() {
        return this.segmentAttributes != null && !(this.segmentAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, SegmentAttributeValue> segmentAttributes() {
        return this.segmentAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferences() ? this.references() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.quickConnectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegmentAttributes() ? this.segmentAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTaskContactRequest)) {
            return false;
        }
        StartTaskContactRequest other = (StartTaskContactRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.previousContactId(), other.previousContactId()) && Objects.equals(this.contactFlowId(), other.contactFlowId()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.name(), other.name()) && this.hasReferences() == other.hasReferences() && Objects.equals(this.references(), other.references()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.scheduledTime(), other.scheduledTime()) && Objects.equals(this.taskTemplateId(), other.taskTemplateId()) && Objects.equals(this.quickConnectId(), other.quickConnectId()) && Objects.equals(this.relatedContactId(), other.relatedContactId()) && this.hasSegmentAttributes() == other.hasSegmentAttributes() && Objects.equals(this.segmentAttributes(), other.segmentAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"StartTaskContactRequest").add("InstanceId", (Object)this.instanceId()).add("PreviousContactId", (Object)this.previousContactId()).add("ContactFlowId", (Object)this.contactFlowId()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("References", this.hasReferences() ? this.references() : null).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientToken", (Object)this.clientToken()).add("ScheduledTime", (Object)this.scheduledTime()).add("TaskTemplateId", (Object)this.taskTemplateId()).add("QuickConnectId", (Object)this.quickConnectId()).add("RelatedContactId", (Object)this.relatedContactId()).add("SegmentAttributes", this.hasSegmentAttributes() ? this.segmentAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "PreviousContactId": {
                return Optional.ofNullable(clazz.cast(this.previousContactId()));
            }
            case "ContactFlowId": {
                return Optional.ofNullable(clazz.cast(this.contactFlowId()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "References": {
                return Optional.ofNullable(clazz.cast(this.references()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ScheduledTime": {
                return Optional.ofNullable(clazz.cast(this.scheduledTime()));
            }
            case "TaskTemplateId": {
                return Optional.ofNullable(clazz.cast(this.taskTemplateId()));
            }
            case "QuickConnectId": {
                return Optional.ofNullable(clazz.cast(this.quickConnectId()));
            }
            case "RelatedContactId": {
                return Optional.ofNullable(clazz.cast(this.relatedContactId()));
            }
            case "SegmentAttributes": {
                return Optional.ofNullable(clazz.cast(this.segmentAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartTaskContactRequest, T> g) {
        return obj -> g.apply((StartTaskContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String previousContactId;
        private String contactFlowId;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String name;
        private Map<String, Reference> references = DefaultSdkAutoConstructMap.getInstance();
        private String description;
        private String clientToken;
        private Instant scheduledTime;
        private String taskTemplateId;
        private String quickConnectId;
        private String relatedContactId;
        private Map<String, SegmentAttributeValue> segmentAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartTaskContactRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.previousContactId(model.previousContactId);
            this.contactFlowId(model.contactFlowId);
            this.attributes(model.attributes);
            this.name(model.name);
            this.references(model.references);
            this.description(model.description);
            this.clientToken(model.clientToken);
            this.scheduledTime(model.scheduledTime);
            this.taskTemplateId(model.taskTemplateId);
            this.quickConnectId(model.quickConnectId);
            this.relatedContactId(model.relatedContactId);
            this.segmentAttributes(model.segmentAttributes);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getPreviousContactId() {
            return this.previousContactId;
        }

        public final void setPreviousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
        }

        @Override
        public final Builder previousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
            return this;
        }

        public final String getContactFlowId() {
            return this.contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, Reference.Builder> getReferences() {
            Map<String, Reference.Builder> result = ContactReferencesCopier.copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setReferences(Map<String, Reference.BuilderImpl> references) {
            this.references = ContactReferencesCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Map<String, Reference> references) {
            this.references = ContactReferencesCopier.copy(references);
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Instant getScheduledTime() {
            return this.scheduledTime;
        }

        public final void setScheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        @Override
        public final Builder scheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
            return this;
        }

        public final String getTaskTemplateId() {
            return this.taskTemplateId;
        }

        public final void setTaskTemplateId(String taskTemplateId) {
            this.taskTemplateId = taskTemplateId;
        }

        @Override
        public final Builder taskTemplateId(String taskTemplateId) {
            this.taskTemplateId = taskTemplateId;
            return this;
        }

        public final String getQuickConnectId() {
            return this.quickConnectId;
        }

        public final void setQuickConnectId(String quickConnectId) {
            this.quickConnectId = quickConnectId;
        }

        @Override
        public final Builder quickConnectId(String quickConnectId) {
            this.quickConnectId = quickConnectId;
            return this;
        }

        public final String getRelatedContactId() {
            return this.relatedContactId;
        }

        public final void setRelatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
        }

        @Override
        public final Builder relatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
            return this;
        }

        public final Map<String, SegmentAttributeValue.Builder> getSegmentAttributes() {
            Map<String, SegmentAttributeValue.Builder> result = SegmentAttributesCopier.copyToBuilder(this.segmentAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSegmentAttributes(Map<String, SegmentAttributeValue.BuilderImpl> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copyFromBuilder(segmentAttributes);
        }

        @Override
        public final Builder segmentAttributes(Map<String, SegmentAttributeValue> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copy(segmentAttributes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTaskContactRequest build() {
            return new StartTaskContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartTaskContactRequest> {
        public Builder instanceId(String var1);

        public Builder previousContactId(String var1);

        public Builder contactFlowId(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder name(String var1);

        public Builder references(Map<String, Reference> var1);

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder scheduledTime(Instant var1);

        public Builder taskTemplateId(String var1);

        public Builder quickConnectId(String var1);

        public Builder relatedContactId(String var1);

        public Builder segmentAttributes(Map<String, SegmentAttributeValue> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

