/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceInfo> {
    private static final SdkField<String> PLATFORM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformName").getter(DeviceInfo.getter(DeviceInfo::platformName)).setter(DeviceInfo.setter(Builder::platformName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformName").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformVersion").getter(DeviceInfo.getter(DeviceInfo::platformVersion)).setter(DeviceInfo.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystem").getter(DeviceInfo.getter(DeviceInfo::operatingSystem)).setter(DeviceInfo.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_NAME_FIELD, PLATFORM_VERSION_FIELD, OPERATING_SYSTEM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PlatformName", PLATFORM_NAME_FIELD);
            this.put("PlatformVersion", PLATFORM_VERSION_FIELD);
            this.put("OperatingSystem", OPERATING_SYSTEM_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String platformName;
    private final String platformVersion;
    private final String operatingSystem;

    private DeviceInfo(BuilderImpl builder) {
        this.platformName = builder.platformName;
        this.platformVersion = builder.platformVersion;
        this.operatingSystem = builder.operatingSystem;
    }

    public final String platformName() {
        return this.platformName;
    }

    public final String platformVersion() {
        return this.platformVersion;
    }

    public final String operatingSystem() {
        return this.operatingSystem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.platformName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystem());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceInfo)) {
            return false;
        }
        DeviceInfo other = (DeviceInfo)obj;
        return Objects.equals(this.platformName(), other.platformName()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.operatingSystem(), other.operatingSystem());
    }

    public final String toString() {
        return ToString.builder((String)"DeviceInfo").add("PlatformName", (Object)this.platformName()).add("PlatformVersion", (Object)this.platformVersion()).add("OperatingSystem", (Object)this.operatingSystem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformName": {
                return Optional.ofNullable(clazz.cast(this.platformName()));
            }
            case "PlatformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystem()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeviceInfo, T> g) {
        return obj -> g.apply((DeviceInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String platformName;
        private String platformVersion;
        private String operatingSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceInfo model) {
            this.platformName(model.platformName);
            this.platformVersion(model.platformVersion);
            this.operatingSystem(model.operatingSystem);
        }

        public final String getPlatformName() {
            return this.platformName;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public DeviceInfo build() {
            return new DeviceInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceInfo> {
        public Builder platformName(String var1);

        public Builder platformVersion(String var1);

        public Builder operatingSystem(String var1);
    }
}

