/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.Queue;
import software.amazon.awssdk.services.connect.model.QueueSearchSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchQueuesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, SearchQueuesResponse> {
    private static final SdkField<List<Queue>> QUEUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Queues").getter(SearchQueuesResponse.getter(SearchQueuesResponse::queues)).setter(SearchQueuesResponse.setter(Builder::queues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Queue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchQueuesResponse.getter(SearchQueuesResponse::nextToken)).setter(SearchQueuesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateTotalCount").getter(SearchQueuesResponse.getter(SearchQueuesResponse::approximateTotalCount)).setter(SearchQueuesResponse.setter(Builder::approximateTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUES_FIELD, NEXT_TOKEN_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Queues", QUEUES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        }
    });
    private final List<Queue> queues;
    private final String nextToken;
    private final Long approximateTotalCount;

    private SearchQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.queues = builder.queues;
        this.nextToken = builder.nextToken;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    public final boolean hasQueues() {
        return this.queues != null && !(this.queues instanceof SdkAutoConstructList);
    }

    public final List<Queue> queues() {
        return this.queues;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long approximateTotalCount() {
        return this.approximateTotalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueues() ? this.queues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTotalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchQueuesResponse)) {
            return false;
        }
        SearchQueuesResponse other = (SearchQueuesResponse)((Object)obj);
        return this.hasQueues() == other.hasQueues() && Objects.equals(this.queues(), other.queues()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.approximateTotalCount(), other.approximateTotalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchQueuesResponse").add("Queues", this.hasQueues() ? this.queues() : null).add("NextToken", (Object)this.nextToken()).add("ApproximateTotalCount", (Object)this.approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Queues": {
                return Optional.ofNullable(clazz.cast(this.queues()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ApproximateTotalCount": {
                return Optional.ofNullable(clazz.cast(this.approximateTotalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchQueuesResponse, T> g) {
        return obj -> g.apply((SearchQueuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<Queue> queues = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchQueuesResponse model) {
            super(model);
            this.queues(model.queues);
            this.nextToken(model.nextToken);
            this.approximateTotalCount(model.approximateTotalCount);
        }

        public final List<Queue.Builder> getQueues() {
            List<Queue.Builder> result = QueueSearchSummaryListCopier.copyToBuilder(this.queues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueues(Collection<Queue.BuilderImpl> queues) {
            this.queues = QueueSearchSummaryListCopier.copyFromBuilder(queues);
        }

        @Override
        public final Builder queues(Collection<Queue> queues) {
            this.queues = QueueSearchSummaryListCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(Queue ... queues) {
            this.queues(Arrays.asList(queues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(Consumer<Queue.Builder> ... queues) {
            this.queues(Stream.of(queues).map(c -> (Queue)((Queue.Builder)Queue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getApproximateTotalCount() {
            return this.approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchQueuesResponse build() {
            return new SearchQueuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchQueuesResponse> {
        public Builder queues(Collection<Queue> var1);

        public Builder queues(Queue ... var1);

        public Builder queues(Consumer<Queue.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder approximateTotalCount(Long var1);
    }
}

