/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.EvaluationFormItem;
import software.amazon.awssdk.services.connect.model.EvaluationFormItemsListCopier;
import software.amazon.awssdk.services.connect.model.EvaluationFormScoringStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationFormContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationFormContent> {
    private static final SdkField<Integer> EVALUATION_FORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EvaluationFormVersion").getter(EvaluationFormContent.getter(EvaluationFormContent::evaluationFormVersion)).setter(EvaluationFormContent.setter(Builder::evaluationFormVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormVersion").build()}).build();
    private static final SdkField<String> EVALUATION_FORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationFormId").getter(EvaluationFormContent.getter(EvaluationFormContent::evaluationFormId)).setter(EvaluationFormContent.setter(Builder::evaluationFormId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormId").build()}).build();
    private static final SdkField<String> EVALUATION_FORM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationFormArn").getter(EvaluationFormContent.getter(EvaluationFormContent::evaluationFormArn)).setter(EvaluationFormContent.setter(Builder::evaluationFormArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormArn").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(EvaluationFormContent.getter(EvaluationFormContent::title)).setter(EvaluationFormContent.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(EvaluationFormContent.getter(EvaluationFormContent::description)).setter(EvaluationFormContent.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<EvaluationFormItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(EvaluationFormContent.getter(EvaluationFormContent::items)).setter(EvaluationFormContent.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationFormItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EvaluationFormScoringStrategy> SCORING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScoringStrategy").getter(EvaluationFormContent.getter(EvaluationFormContent::scoringStrategy)).setter(EvaluationFormContent.setter(Builder::scoringStrategy)).constructor(EvaluationFormScoringStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoringStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_FORM_VERSION_FIELD, EVALUATION_FORM_ID_FIELD, EVALUATION_FORM_ARN_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, ITEMS_FIELD, SCORING_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EvaluationFormVersion", EVALUATION_FORM_VERSION_FIELD);
            this.put("EvaluationFormId", EVALUATION_FORM_ID_FIELD);
            this.put("EvaluationFormArn", EVALUATION_FORM_ARN_FIELD);
            this.put("Title", TITLE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Items", ITEMS_FIELD);
            this.put("ScoringStrategy", SCORING_STRATEGY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer evaluationFormVersion;
    private final String evaluationFormId;
    private final String evaluationFormArn;
    private final String title;
    private final String description;
    private final List<EvaluationFormItem> items;
    private final EvaluationFormScoringStrategy scoringStrategy;

    private EvaluationFormContent(BuilderImpl builder) {
        this.evaluationFormVersion = builder.evaluationFormVersion;
        this.evaluationFormId = builder.evaluationFormId;
        this.evaluationFormArn = builder.evaluationFormArn;
        this.title = builder.title;
        this.description = builder.description;
        this.items = builder.items;
        this.scoringStrategy = builder.scoringStrategy;
    }

    public final Integer evaluationFormVersion() {
        return this.evaluationFormVersion;
    }

    public final String evaluationFormId() {
        return this.evaluationFormId;
    }

    public final String evaluationFormArn() {
        return this.evaluationFormArn;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<EvaluationFormItem> items() {
        return this.items;
    }

    public final EvaluationFormScoringStrategy scoringStrategy() {
        return this.scoringStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFormVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFormId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFormArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scoringStrategy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormContent)) {
            return false;
        }
        EvaluationFormContent other = (EvaluationFormContent)obj;
        return Objects.equals(this.evaluationFormVersion(), other.evaluationFormVersion()) && Objects.equals(this.evaluationFormId(), other.evaluationFormId()) && Objects.equals(this.evaluationFormArn(), other.evaluationFormArn()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.scoringStrategy(), other.scoringStrategy());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationFormContent").add("EvaluationFormVersion", (Object)this.evaluationFormVersion()).add("EvaluationFormId", (Object)this.evaluationFormId()).add("EvaluationFormArn", (Object)this.evaluationFormArn()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("Items", this.hasItems() ? this.items() : null).add("ScoringStrategy", (Object)this.scoringStrategy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationFormVersion": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormVersion()));
            }
            case "EvaluationFormId": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormId()));
            }
            case "EvaluationFormArn": {
                return Optional.ofNullable(clazz.cast(this.evaluationFormArn()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "ScoringStrategy": {
                return Optional.ofNullable(clazz.cast(this.scoringStrategy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormContent, T> g) {
        return obj -> g.apply((EvaluationFormContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer evaluationFormVersion;
        private String evaluationFormId;
        private String evaluationFormArn;
        private String title;
        private String description;
        private List<EvaluationFormItem> items = DefaultSdkAutoConstructList.getInstance();
        private EvaluationFormScoringStrategy scoringStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormContent model) {
            this.evaluationFormVersion(model.evaluationFormVersion);
            this.evaluationFormId(model.evaluationFormId);
            this.evaluationFormArn(model.evaluationFormArn);
            this.title(model.title);
            this.description(model.description);
            this.items(model.items);
            this.scoringStrategy(model.scoringStrategy);
        }

        public final Integer getEvaluationFormVersion() {
            return this.evaluationFormVersion;
        }

        public final void setEvaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
        }

        @Override
        public final Builder evaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
            return this;
        }

        public final String getEvaluationFormId() {
            return this.evaluationFormId;
        }

        public final void setEvaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
        }

        @Override
        public final Builder evaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
            return this;
        }

        public final String getEvaluationFormArn() {
            return this.evaluationFormArn;
        }

        public final void setEvaluationFormArn(String evaluationFormArn) {
            this.evaluationFormArn = evaluationFormArn;
        }

        @Override
        public final Builder evaluationFormArn(String evaluationFormArn) {
            this.evaluationFormArn = evaluationFormArn;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<EvaluationFormItem.Builder> getItems() {
            List<EvaluationFormItem.Builder> result = EvaluationFormItemsListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<EvaluationFormItem.BuilderImpl> items) {
            this.items = EvaluationFormItemsListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<EvaluationFormItem> items) {
            this.items = EvaluationFormItemsListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(EvaluationFormItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<EvaluationFormItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (EvaluationFormItem)((EvaluationFormItem.Builder)EvaluationFormItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EvaluationFormScoringStrategy.Builder getScoringStrategy() {
            return this.scoringStrategy != null ? this.scoringStrategy.toBuilder() : null;
        }

        public final void setScoringStrategy(EvaluationFormScoringStrategy.BuilderImpl scoringStrategy) {
            this.scoringStrategy = scoringStrategy != null ? scoringStrategy.build() : null;
        }

        @Override
        public final Builder scoringStrategy(EvaluationFormScoringStrategy scoringStrategy) {
            this.scoringStrategy = scoringStrategy;
            return this;
        }

        public EvaluationFormContent build() {
            return new EvaluationFormContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationFormContent> {
        public Builder evaluationFormVersion(Integer var1);

        public Builder evaluationFormId(String var1);

        public Builder evaluationFormArn(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder items(Collection<EvaluationFormItem> var1);

        public Builder items(EvaluationFormItem ... var1);

        public Builder items(Consumer<EvaluationFormItem.Builder> ... var1);

        public Builder scoringStrategy(EvaluationFormScoringStrategy var1);

        default public Builder scoringStrategy(Consumer<EvaluationFormScoringStrategy.Builder> scoringStrategy) {
            return this.scoringStrategy((EvaluationFormScoringStrategy)((EvaluationFormScoringStrategy.Builder)EvaluationFormScoringStrategy.builder().applyMutation(scoringStrategy)).build());
        }
    }
}

