/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ContactSearchSummary;
import software.amazon.awssdk.services.connect.model.SearchContactsRequest;
import software.amazon.awssdk.services.connect.model.SearchContactsResponse;

public class SearchContactsIterable
implements SdkIterable<SearchContactsResponse> {
    private final ConnectClient client;
    private final SearchContactsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchContactsIterable(ConnectClient client, SearchContactsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchContactsResponseFetcher();
    }

    public Iterator<SearchContactsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContactSearchSummary> contacts() {
        Function<SearchContactsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contacts() != null) {
                return response.contacts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchContactsResponseFetcher
    implements SyncPageFetcher<SearchContactsResponse> {
        private SearchContactsResponseFetcher() {
        }

        public boolean hasNextPage(SearchContactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchContactsResponse nextPage(SearchContactsResponse previousPage) {
            if (previousPage == null) {
                return SearchContactsIterable.this.client.searchContacts(SearchContactsIterable.this.firstRequest);
            }
            return SearchContactsIterable.this.client.searchContacts((SearchContactsRequest)((Object)SearchContactsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

