/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListPredefinedAttributesRequest;
import software.amazon.awssdk.services.connect.model.ListPredefinedAttributesResponse;
import software.amazon.awssdk.services.connect.model.PredefinedAttributeSummary;

public class ListPredefinedAttributesIterable
implements SdkIterable<ListPredefinedAttributesResponse> {
    private final ConnectClient client;
    private final ListPredefinedAttributesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPredefinedAttributesIterable(ConnectClient client, ListPredefinedAttributesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPredefinedAttributesResponseFetcher();
    }

    public Iterator<ListPredefinedAttributesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PredefinedAttributeSummary> predefinedAttributeSummaryList() {
        Function<ListPredefinedAttributesResponse, Iterator> getIterator = response -> {
            if (response != null && response.predefinedAttributeSummaryList() != null) {
                return response.predefinedAttributeSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPredefinedAttributesResponseFetcher
    implements SyncPageFetcher<ListPredefinedAttributesResponse> {
        private ListPredefinedAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListPredefinedAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPredefinedAttributesResponse nextPage(ListPredefinedAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListPredefinedAttributesIterable.this.client.listPredefinedAttributes(ListPredefinedAttributesIterable.this.firstRequest);
            }
            return ListPredefinedAttributesIterable.this.client.listPredefinedAttributes((ListPredefinedAttributesRequest)((Object)ListPredefinedAttributesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

