/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePromptRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdatePromptRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdatePromptRequest.getter(UpdatePromptRequest::instanceId)).setter(UpdatePromptRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> PROMPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PromptId").getter(UpdatePromptRequest.getter(UpdatePromptRequest::promptId)).setter(UpdatePromptRequest.setter(Builder::promptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("PromptId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdatePromptRequest.getter(UpdatePromptRequest::name)).setter(UpdatePromptRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdatePromptRequest.getter(UpdatePromptRequest::description)).setter(UpdatePromptRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Uri").getter(UpdatePromptRequest.getter(UpdatePromptRequest::s3Uri)).setter(UpdatePromptRequest.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, PROMPT_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, S3_URI_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceId", INSTANCE_ID_FIELD);
            this.put("PromptId", PROMPT_ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("S3Uri", S3_URI_FIELD);
        }
    });
    private final String instanceId;
    private final String promptId;
    private final String name;
    private final String description;
    private final String s3Uri;

    private UpdatePromptRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.promptId = builder.promptId;
        this.name = builder.name;
        this.description = builder.description;
        this.s3Uri = builder.s3Uri;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String promptId() {
        return this.promptId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePromptRequest)) {
            return false;
        }
        UpdatePromptRequest other = (UpdatePromptRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.promptId(), other.promptId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.s3Uri(), other.s3Uri());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePromptRequest").add("InstanceId", (Object)this.instanceId()).add("PromptId", (Object)this.promptId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("S3Uri", (Object)this.s3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "PromptId": {
                return Optional.ofNullable(clazz.cast(this.promptId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePromptRequest, T> g) {
        return obj -> g.apply((UpdatePromptRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String promptId;
        private String name;
        private String description;
        private String s3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePromptRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.promptId(model.promptId);
            this.name(model.name);
            this.description(model.description);
            this.s3Uri(model.s3Uri);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getPromptId() {
            return this.promptId;
        }

        public final void setPromptId(String promptId) {
            this.promptId = promptId;
        }

        @Override
        public final Builder promptId(String promptId) {
            this.promptId = promptId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePromptRequest build() {
            return new UpdatePromptRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePromptRequest> {
        public Builder instanceId(String var1);

        public Builder promptId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder s3Uri(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

