/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ParticipantRole;
import software.amazon.awssdk.services.connect.model.SearchContactsMatchType;
import software.amazon.awssdk.services.connect.model.SearchTextListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TranscriptCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TranscriptCriteria> {
    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantRole").getter(TranscriptCriteria.getter(TranscriptCriteria::participantRoleAsString)).setter(TranscriptCriteria.setter(Builder::participantRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()}).build();
    private static final SdkField<List<String>> SEARCH_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SearchText").getter(TranscriptCriteria.getter(TranscriptCriteria::searchText)).setter(TranscriptCriteria.setter(Builder::searchText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchText").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MATCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatchType").getter(TranscriptCriteria.getter(TranscriptCriteria::matchTypeAsString)).setter(TranscriptCriteria.setter(Builder::matchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTICIPANT_ROLE_FIELD, SEARCH_TEXT_FIELD, MATCH_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ParticipantRole", PARTICIPANT_ROLE_FIELD);
            this.put("SearchText", SEARCH_TEXT_FIELD);
            this.put("MatchType", MATCH_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String participantRole;
    private final List<String> searchText;
    private final String matchType;

    private TranscriptCriteria(BuilderImpl builder) {
        this.participantRole = builder.participantRole;
        this.searchText = builder.searchText;
        this.matchType = builder.matchType;
    }

    public final ParticipantRole participantRole() {
        return ParticipantRole.fromValue(this.participantRole);
    }

    public final String participantRoleAsString() {
        return this.participantRole;
    }

    public final boolean hasSearchText() {
        return this.searchText != null && !(this.searchText instanceof SdkAutoConstructList);
    }

    public final List<String> searchText() {
        return this.searchText;
    }

    public final SearchContactsMatchType matchType() {
        return SearchContactsMatchType.fromValue(this.matchType);
    }

    public final String matchTypeAsString() {
        return this.matchType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.participantRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSearchText() ? this.searchText() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.matchTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranscriptCriteria)) {
            return false;
        }
        TranscriptCriteria other = (TranscriptCriteria)obj;
        return Objects.equals(this.participantRoleAsString(), other.participantRoleAsString()) && this.hasSearchText() == other.hasSearchText() && Objects.equals(this.searchText(), other.searchText()) && Objects.equals(this.matchTypeAsString(), other.matchTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TranscriptCriteria").add("ParticipantRole", (Object)this.participantRoleAsString()).add("SearchText", (Object)(this.searchText() == null ? null : "*** Sensitive Data Redacted ***")).add("MatchType", (Object)this.matchTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParticipantRole": {
                return Optional.ofNullable(clazz.cast(this.participantRoleAsString()));
            }
            case "SearchText": {
                return Optional.ofNullable(clazz.cast(this.searchText()));
            }
            case "MatchType": {
                return Optional.ofNullable(clazz.cast(this.matchTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TranscriptCriteria, T> g) {
        return obj -> g.apply((TranscriptCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String participantRole;
        private List<String> searchText = DefaultSdkAutoConstructList.getInstance();
        private String matchType;

        private BuilderImpl() {
        }

        private BuilderImpl(TranscriptCriteria model) {
            this.participantRole(model.participantRole);
            this.searchText(model.searchText);
            this.matchType(model.matchType);
        }

        public final String getParticipantRole() {
            return this.participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(ParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public final Collection<String> getSearchText() {
            if (this.searchText instanceof SdkAutoConstructList) {
                return null;
            }
            return this.searchText;
        }

        public final void setSearchText(Collection<String> searchText) {
            this.searchText = SearchTextListCopier.copy(searchText);
        }

        @Override
        public final Builder searchText(Collection<String> searchText) {
            this.searchText = SearchTextListCopier.copy(searchText);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchText(String ... searchText) {
            this.searchText(Arrays.asList(searchText));
            return this;
        }

        public final String getMatchType() {
            return this.matchType;
        }

        public final void setMatchType(String matchType) {
            this.matchType = matchType;
        }

        @Override
        public final Builder matchType(String matchType) {
            this.matchType = matchType;
            return this;
        }

        @Override
        public final Builder matchType(SearchContactsMatchType matchType) {
            this.matchType(matchType == null ? null : matchType.toString());
            return this;
        }

        public TranscriptCriteria build() {
            return new TranscriptCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TranscriptCriteria> {
        public Builder participantRole(String var1);

        public Builder participantRole(ParticipantRole var1);

        public Builder searchText(Collection<String> var1);

        public Builder searchText(String ... var1);

        public Builder matchType(String var1);

        public Builder matchType(SearchContactsMatchType var1);
    }
}

