/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.PromptSearchCriteria;
import software.amazon.awssdk.services.connect.model.PromptSearchFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchPromptsRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, SearchPromptsRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(SearchPromptsRequest.getter(SearchPromptsRequest::instanceId)).setter(SearchPromptsRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchPromptsRequest.getter(SearchPromptsRequest::nextToken)).setter(SearchPromptsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(SearchPromptsRequest.getter(SearchPromptsRequest::maxResults)).setter(SearchPromptsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<PromptSearchFilter> SEARCH_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SearchFilter").getter(SearchPromptsRequest.getter(SearchPromptsRequest::searchFilter)).setter(SearchPromptsRequest.setter(Builder::searchFilter)).constructor(PromptSearchFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchFilter").build()}).build();
    private static final SdkField<PromptSearchCriteria> SEARCH_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SearchCriteria").getter(SearchPromptsRequest.getter(SearchPromptsRequest::searchCriteria)).setter(SearchPromptsRequest.setter(Builder::searchCriteria)).constructor(PromptSearchCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchCriteria").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SEARCH_FILTER_FIELD, SEARCH_CRITERIA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceId", INSTANCE_ID_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("SearchFilter", SEARCH_FILTER_FIELD);
            this.put("SearchCriteria", SEARCH_CRITERIA_FIELD);
        }
    });
    private final String instanceId;
    private final String nextToken;
    private final Integer maxResults;
    private final PromptSearchFilter searchFilter;
    private final PromptSearchCriteria searchCriteria;

    private SearchPromptsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.searchFilter = builder.searchFilter;
        this.searchCriteria = builder.searchCriteria;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final PromptSearchFilter searchFilter() {
        return this.searchFilter;
    }

    public final PromptSearchCriteria searchCriteria() {
        return this.searchCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchCriteria());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPromptsRequest)) {
            return false;
        }
        SearchPromptsRequest other = (SearchPromptsRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.searchFilter(), other.searchFilter()) && Objects.equals(this.searchCriteria(), other.searchCriteria());
    }

    public final String toString() {
        return ToString.builder((String)"SearchPromptsRequest").add("InstanceId", (Object)this.instanceId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("SearchFilter", (Object)this.searchFilter()).add("SearchCriteria", (Object)this.searchCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "SearchFilter": {
                return Optional.ofNullable(clazz.cast(this.searchFilter()));
            }
            case "SearchCriteria": {
                return Optional.ofNullable(clazz.cast(this.searchCriteria()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchPromptsRequest, T> g) {
        return obj -> g.apply((SearchPromptsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String nextToken;
        private Integer maxResults;
        private PromptSearchFilter searchFilter;
        private PromptSearchCriteria searchCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPromptsRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.searchFilter(model.searchFilter);
            this.searchCriteria(model.searchCriteria);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final PromptSearchFilter.Builder getSearchFilter() {
            return this.searchFilter != null ? this.searchFilter.toBuilder() : null;
        }

        public final void setSearchFilter(PromptSearchFilter.BuilderImpl searchFilter) {
            this.searchFilter = searchFilter != null ? searchFilter.build() : null;
        }

        @Override
        public final Builder searchFilter(PromptSearchFilter searchFilter) {
            this.searchFilter = searchFilter;
            return this;
        }

        public final PromptSearchCriteria.Builder getSearchCriteria() {
            return this.searchCriteria != null ? this.searchCriteria.toBuilder() : null;
        }

        public final void setSearchCriteria(PromptSearchCriteria.BuilderImpl searchCriteria) {
            this.searchCriteria = searchCriteria != null ? searchCriteria.build() : null;
        }

        @Override
        public final Builder searchCriteria(PromptSearchCriteria searchCriteria) {
            this.searchCriteria = searchCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchPromptsRequest build() {
            return new SearchPromptsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchPromptsRequest> {
        public Builder instanceId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder searchFilter(PromptSearchFilter var1);

        default public Builder searchFilter(Consumer<PromptSearchFilter.Builder> searchFilter) {
            return this.searchFilter((PromptSearchFilter)((PromptSearchFilter.Builder)PromptSearchFilter.builder().applyMutation(searchFilter)).build());
        }

        public Builder searchCriteria(PromptSearchCriteria var1);

        default public Builder searchCriteria(Consumer<PromptSearchCriteria.Builder> searchCriteria) {
            return this.searchCriteria((PromptSearchCriteria)((PromptSearchCriteria.Builder)PromptSearchCriteria.builder().applyMutation(searchCriteria)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

