/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.ContactSearchSummary;
import software.amazon.awssdk.services.connect.model.ContactsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchContactsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, SearchContactsResponse> {
    private static final SdkField<List<ContactSearchSummary>> CONTACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Contacts").getter(SearchContactsResponse.getter(SearchContactsResponse::contacts)).setter(SearchContactsResponse.setter(Builder::contacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactSearchSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchContactsResponse.getter(SearchContactsResponse::nextToken)).setter(SearchContactsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalCount").getter(SearchContactsResponse.getter(SearchContactsResponse::totalCount)).setter(SearchContactsResponse.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACTS_FIELD, NEXT_TOKEN_FIELD, TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Contacts", CONTACTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("TotalCount", TOTAL_COUNT_FIELD);
        }
    });
    private final List<ContactSearchSummary> contacts;
    private final String nextToken;
    private final Long totalCount;

    private SearchContactsResponse(BuilderImpl builder) {
        super(builder);
        this.contacts = builder.contacts;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    public final boolean hasContacts() {
        return this.contacts != null && !(this.contacts instanceof SdkAutoConstructList);
    }

    public final List<ContactSearchSummary> contacts() {
        return this.contacts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContacts() ? this.contacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchContactsResponse)) {
            return false;
        }
        SearchContactsResponse other = (SearchContactsResponse)((Object)obj);
        return this.hasContacts() == other.hasContacts() && Objects.equals(this.contacts(), other.contacts()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.totalCount(), other.totalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchContactsResponse").add("Contacts", this.hasContacts() ? this.contacts() : null).add("NextToken", (Object)this.nextToken()).add("TotalCount", (Object)this.totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Contacts": {
                return Optional.ofNullable(clazz.cast(this.contacts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchContactsResponse, T> g) {
        return obj -> g.apply((SearchContactsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<ContactSearchSummary> contacts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchContactsResponse model) {
            super(model);
            this.contacts(model.contacts);
            this.nextToken(model.nextToken);
            this.totalCount(model.totalCount);
        }

        public final List<ContactSearchSummary.Builder> getContacts() {
            List<ContactSearchSummary.Builder> result = ContactsCopier.copyToBuilder(this.contacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContacts(Collection<ContactSearchSummary.BuilderImpl> contacts) {
            this.contacts = ContactsCopier.copyFromBuilder(contacts);
        }

        @Override
        public final Builder contacts(Collection<ContactSearchSummary> contacts) {
            this.contacts = ContactsCopier.copy(contacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(ContactSearchSummary ... contacts) {
            this.contacts(Arrays.asList(contacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Consumer<ContactSearchSummary.Builder> ... contacts) {
            this.contacts(Stream.of(contacts).map(c -> (ContactSearchSummary)((ContactSearchSummary.Builder)ContactSearchSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getTotalCount() {
            return this.totalCount;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public SearchContactsResponse build() {
            return new SearchContactsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchContactsResponse> {
        public Builder contacts(Collection<ContactSearchSummary> var1);

        public Builder contacts(ContactSearchSummary ... var1);

        public Builder contacts(Consumer<ContactSearchSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder totalCount(Long var1);
    }
}

