/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AgentStatus;
import software.amazon.awssdk.services.connect.model.AgentStatusListCopier;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchAgentStatusesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, SearchAgentStatusesResponse> {
    private static final SdkField<List<AgentStatus>> AGENT_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentStatuses").getter(SearchAgentStatusesResponse.getter(SearchAgentStatusesResponse::agentStatuses)).setter(SearchAgentStatusesResponse.setter(Builder::agentStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchAgentStatusesResponse.getter(SearchAgentStatusesResponse::nextToken)).setter(SearchAgentStatusesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateTotalCount").getter(SearchAgentStatusesResponse.getter(SearchAgentStatusesResponse::approximateTotalCount)).setter(SearchAgentStatusesResponse.setter(Builder::approximateTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_STATUSES_FIELD, NEXT_TOKEN_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AgentStatuses", AGENT_STATUSES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        }
    });
    private final List<AgentStatus> agentStatuses;
    private final String nextToken;
    private final Long approximateTotalCount;

    private SearchAgentStatusesResponse(BuilderImpl builder) {
        super(builder);
        this.agentStatuses = builder.agentStatuses;
        this.nextToken = builder.nextToken;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    public final boolean hasAgentStatuses() {
        return this.agentStatuses != null && !(this.agentStatuses instanceof SdkAutoConstructList);
    }

    public final List<AgentStatus> agentStatuses() {
        return this.agentStatuses;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long approximateTotalCount() {
        return this.approximateTotalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentStatuses() ? this.agentStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTotalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAgentStatusesResponse)) {
            return false;
        }
        SearchAgentStatusesResponse other = (SearchAgentStatusesResponse)((Object)obj);
        return this.hasAgentStatuses() == other.hasAgentStatuses() && Objects.equals(this.agentStatuses(), other.agentStatuses()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.approximateTotalCount(), other.approximateTotalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchAgentStatusesResponse").add("AgentStatuses", this.hasAgentStatuses() ? this.agentStatuses() : null).add("NextToken", (Object)this.nextToken()).add("ApproximateTotalCount", (Object)this.approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AgentStatuses": {
                return Optional.ofNullable(clazz.cast(this.agentStatuses()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ApproximateTotalCount": {
                return Optional.ofNullable(clazz.cast(this.approximateTotalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchAgentStatusesResponse, T> g) {
        return obj -> g.apply((SearchAgentStatusesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<AgentStatus> agentStatuses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAgentStatusesResponse model) {
            super(model);
            this.agentStatuses(model.agentStatuses);
            this.nextToken(model.nextToken);
            this.approximateTotalCount(model.approximateTotalCount);
        }

        public final List<AgentStatus.Builder> getAgentStatuses() {
            List<AgentStatus.Builder> result = AgentStatusListCopier.copyToBuilder(this.agentStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentStatuses(Collection<AgentStatus.BuilderImpl> agentStatuses) {
            this.agentStatuses = AgentStatusListCopier.copyFromBuilder(agentStatuses);
        }

        @Override
        public final Builder agentStatuses(Collection<AgentStatus> agentStatuses) {
            this.agentStatuses = AgentStatusListCopier.copy(agentStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentStatuses(AgentStatus ... agentStatuses) {
            this.agentStatuses(Arrays.asList(agentStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentStatuses(Consumer<AgentStatus.Builder> ... agentStatuses) {
            this.agentStatuses(Stream.of(agentStatuses).map(c -> (AgentStatus)((AgentStatus.Builder)AgentStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getApproximateTotalCount() {
            return this.approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchAgentStatusesResponse build() {
            return new SearchAgentStatusesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchAgentStatusesResponse> {
        public Builder agentStatuses(Collection<AgentStatus> var1);

        public Builder agentStatuses(AgentStatus ... var1);

        public Builder agentStatuses(Consumer<AgentStatus.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder approximateTotalCount(Long var1);
    }
}

