/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.EventSourceName;
import software.amazon.awssdk.services.connect.model.RulePublishStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRulesRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, ListRulesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ListRulesRequest.getter(ListRulesRequest::instanceId)).setter(ListRulesRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> PUBLISH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublishStatus").getter(ListRulesRequest.getter(ListRulesRequest::publishStatusAsString)).setter(ListRulesRequest.setter(Builder::publishStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("publishStatus").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSourceName").getter(ListRulesRequest.getter(ListRulesRequest::eventSourceNameAsString)).setter(ListRulesRequest.setter(Builder::eventSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("eventSourceName").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListRulesRequest.getter(ListRulesRequest::maxResults)).setter(ListRulesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRulesRequest.getter(ListRulesRequest::nextToken)).setter(ListRulesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, PUBLISH_STATUS_FIELD, EVENT_SOURCE_NAME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceId", INSTANCE_ID_FIELD);
            this.put("publishStatus", PUBLISH_STATUS_FIELD);
            this.put("eventSourceName", EVENT_SOURCE_NAME_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String instanceId;
    private final String publishStatus;
    private final String eventSourceName;
    private final Integer maxResults;
    private final String nextToken;

    private ListRulesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.publishStatus = builder.publishStatus;
        this.eventSourceName = builder.eventSourceName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final RulePublishStatus publishStatus() {
        return RulePublishStatus.fromValue(this.publishStatus);
    }

    public final String publishStatusAsString() {
        return this.publishStatus;
    }

    public final EventSourceName eventSourceName() {
        return EventSourceName.fromValue(this.eventSourceName);
    }

    public final String eventSourceNameAsString() {
        return this.eventSourceName;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRulesRequest)) {
            return false;
        }
        ListRulesRequest other = (ListRulesRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.publishStatusAsString(), other.publishStatusAsString()) && Objects.equals(this.eventSourceNameAsString(), other.eventSourceNameAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRulesRequest").add("InstanceId", (Object)this.instanceId()).add("PublishStatus", (Object)this.publishStatusAsString()).add("EventSourceName", (Object)this.eventSourceNameAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "PublishStatus": {
                return Optional.ofNullable(clazz.cast(this.publishStatusAsString()));
            }
            case "EventSourceName": {
                return Optional.ofNullable(clazz.cast(this.eventSourceNameAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRulesRequest, T> g) {
        return obj -> g.apply((ListRulesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String publishStatus;
        private String eventSourceName;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRulesRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.publishStatus(model.publishStatus);
            this.eventSourceName(model.eventSourceName);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getPublishStatus() {
            return this.publishStatus;
        }

        public final void setPublishStatus(String publishStatus) {
            this.publishStatus = publishStatus;
        }

        @Override
        public final Builder publishStatus(String publishStatus) {
            this.publishStatus = publishStatus;
            return this;
        }

        @Override
        public final Builder publishStatus(RulePublishStatus publishStatus) {
            this.publishStatus(publishStatus == null ? null : publishStatus.toString());
            return this;
        }

        public final String getEventSourceName() {
            return this.eventSourceName;
        }

        public final void setEventSourceName(String eventSourceName) {
            this.eventSourceName = eventSourceName;
        }

        @Override
        public final Builder eventSourceName(String eventSourceName) {
            this.eventSourceName = eventSourceName;
            return this;
        }

        @Override
        public final Builder eventSourceName(EventSourceName eventSourceName) {
            this.eventSourceName(eventSourceName == null ? null : eventSourceName.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRulesRequest build() {
            return new ListRulesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRulesRequest> {
        public Builder instanceId(String var1);

        public Builder publishStatus(String var1);

        public Builder publishStatus(RulePublishStatus var1);

        public Builder eventSourceName(String var1);

        public Builder eventSourceName(EventSourceName var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

