/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.FilterValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterV2
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterV2> {
    private static final SdkField<String> FILTER_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterKey").getter(FilterV2.getter(FilterV2::filterKey)).setter(FilterV2.setter(Builder::filterKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterKey").build()}).build();
    private static final SdkField<List<String>> FILTER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterValues").getter(FilterV2.getter(FilterV2::filterValues)).setter(FilterV2.setter(Builder::filterValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_KEY_FIELD, FILTER_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FilterKey", FILTER_KEY_FIELD);
            this.put("FilterValues", FILTER_VALUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String filterKey;
    private final List<String> filterValues;

    private FilterV2(BuilderImpl builder) {
        this.filterKey = builder.filterKey;
        this.filterValues = builder.filterValues;
    }

    public final String filterKey() {
        return this.filterKey;
    }

    public final boolean hasFilterValues() {
        return this.filterValues != null && !(this.filterValues instanceof SdkAutoConstructList);
    }

    public final List<String> filterValues() {
        return this.filterValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterValues() ? this.filterValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterV2)) {
            return false;
        }
        FilterV2 other = (FilterV2)obj;
        return Objects.equals(this.filterKey(), other.filterKey()) && this.hasFilterValues() == other.hasFilterValues() && Objects.equals(this.filterValues(), other.filterValues());
    }

    public final String toString() {
        return ToString.builder((String)"FilterV2").add("FilterKey", (Object)this.filterKey()).add("FilterValues", this.hasFilterValues() ? this.filterValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterKey": {
                return Optional.ofNullable(clazz.cast(this.filterKey()));
            }
            case "FilterValues": {
                return Optional.ofNullable(clazz.cast(this.filterValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FilterV2, T> g) {
        return obj -> g.apply((FilterV2)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterKey;
        private List<String> filterValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FilterV2 model) {
            this.filterKey(model.filterKey);
            this.filterValues(model.filterValues);
        }

        public final String getFilterKey() {
            return this.filterKey;
        }

        public final void setFilterKey(String filterKey) {
            this.filterKey = filterKey;
        }

        @Override
        public final Builder filterKey(String filterKey) {
            this.filterKey = filterKey;
            return this;
        }

        public final Collection<String> getFilterValues() {
            if (this.filterValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterValues;
        }

        public final void setFilterValues(Collection<String> filterValues) {
            this.filterValues = FilterValueListCopier.copy(filterValues);
        }

        @Override
        public final Builder filterValues(Collection<String> filterValues) {
            this.filterValues = FilterValueListCopier.copy(filterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterValues(String ... filterValues) {
            this.filterValues(Arrays.asList(filterValues));
            return this;
        }

        public FilterV2 build() {
            return new FilterV2(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterV2> {
        public Builder filterKey(String var1);

        public Builder filterValues(Collection<String> var1);

        public Builder filterValues(String ... var1);
    }
}

